/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains content regarding the reasoning that is carried out by the model with respect to the content in the content
 * block. Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance the accuracy of its final
 * response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReasoningContentBlockDelta implements SdkPojo, Serializable,
        ToCopyableBuilder<ReasoningContentBlockDelta.Builder, ReasoningContentBlockDelta> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(ReasoningContentBlockDelta::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<SdkBytes> REDACTED_CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("redactedContent").getter(getter(ReasoningContentBlockDelta::redactedContent))
            .setter(setter(Builder::redactedContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redactedContent").build()).build();

    private static final SdkField<String> SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signature").getter(getter(ReasoningContentBlockDelta::signature)).setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD,
            REDACTED_CONTENT_FIELD, SIGNATURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String text;

    private final SdkBytes redactedContent;

    private final String signature;

    private final Type type;

    private ReasoningContentBlockDelta(BuilderImpl builder) {
        this.text = builder.text;
        this.redactedContent = builder.redactedContent;
        this.signature = builder.signature;
        this.type = builder.type;
    }

    /**
     * <p>
     * The reasoning that the model used to return the output.
     * </p>
     * 
     * @return The reasoning that the model used to return the output.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The content in the reasoning that was encrypted by the model provider for safety reasons. The encryption doesn't
     * affect the quality of responses.
     * </p>
     * 
     * @return The content in the reasoning that was encrypted by the model provider for safety reasons. The encryption
     *         doesn't affect the quality of responses.
     */
    public final SdkBytes redactedContent() {
        return redactedContent;
    }

    /**
     * <p>
     * A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block back to
     * the API in a multi-turn conversation, include the text and its signature unmodified.
     * </p>
     * 
     * @return A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block
     *         back to the API in a multi-turn conversation, include the text and its signature unmodified.
     */
    public final String signature() {
        return signature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(redactedContent());
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReasoningContentBlockDelta)) {
            return false;
        }
        ReasoningContentBlockDelta other = (ReasoningContentBlockDelta) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(redactedContent(), other.redactedContent())
                && Objects.equals(signature(), other.signature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReasoningContentBlockDelta").add("Text", text()).add("RedactedContent", redactedContent())
                .add("Signature", signature()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "redactedContent":
            return Optional.ofNullable(clazz.cast(redactedContent()));
        case "signature":
            return Optional.ofNullable(clazz.cast(signature()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * The reasoning that the model used to return the output.
     * </p>
     * 
     * @param text
     *        The reasoning that the model used to return the output.
     */
    public static ReasoningContentBlockDelta fromText(String text) {
        return builder().text(text).build();
    }

    /**
     * Create an instance of this class with {@link #redactedContent()} initialized to the given value.
     *
     * <p>
     * The content in the reasoning that was encrypted by the model provider for safety reasons. The encryption doesn't
     * affect the quality of responses.
     * </p>
     * 
     * @param redactedContent
     *        The content in the reasoning that was encrypted by the model provider for safety reasons. The encryption
     *        doesn't affect the quality of responses.
     */
    public static ReasoningContentBlockDelta fromRedactedContent(SdkBytes redactedContent) {
        return builder().redactedContent(redactedContent).build();
    }

    /**
     * Create an instance of this class with {@link #signature()} initialized to the given value.
     *
     * <p>
     * A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block back to
     * the API in a multi-turn conversation, include the text and its signature unmodified.
     * </p>
     * 
     * @param signature
     *        A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block
     *        back to the API in a multi-turn conversation, include the text and its signature unmodified.
     */
    public static ReasoningContentBlockDelta fromSignature(String signature) {
        return builder().signature(signature).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("redactedContent", REDACTED_CONTENT_FIELD);
        map.put("signature", SIGNATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReasoningContentBlockDelta, T> g) {
        return obj -> g.apply((ReasoningContentBlockDelta) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReasoningContentBlockDelta> {
        /**
         * <p>
         * The reasoning that the model used to return the output.
         * </p>
         * 
         * @param text
         *        The reasoning that the model used to return the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The content in the reasoning that was encrypted by the model provider for safety reasons. The encryption
         * doesn't affect the quality of responses.
         * </p>
         * 
         * @param redactedContent
         *        The content in the reasoning that was encrypted by the model provider for safety reasons. The
         *        encryption doesn't affect the quality of responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redactedContent(SdkBytes redactedContent);

        /**
         * <p>
         * A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block back
         * to the API in a multi-turn conversation, include the text and its signature unmodified.
         * </p>
         * 
         * @param signature
         *        A token that verifies that the reasoning text was generated by the model. If you pass a reasoning
         *        block back to the API in a multi-turn conversation, include the text and its signature unmodified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private SdkBytes redactedContent;

        private String signature;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReasoningContentBlockDelta model) {
            text(model.text);
            redactedContent(model.redactedContent);
            signature(model.signature);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ByteBuffer getRedactedContent() {
            return redactedContent == null ? null : redactedContent.asByteBuffer();
        }

        public final void setRedactedContent(ByteBuffer redactedContent) {
            redactedContent(redactedContent == null ? null : SdkBytes.fromByteBuffer(redactedContent));
        }

        @Override
        public final Builder redactedContent(SdkBytes redactedContent) {
            Object oldValue = this.redactedContent;
            this.redactedContent = redactedContent;
            handleUnionValueChange(Type.REDACTED_CONTENT, oldValue, this.redactedContent);
            return this;
        }

        public final String getSignature() {
            return signature;
        }

        public final void setSignature(String signature) {
            Object oldValue = this.signature;
            this.signature = signature;
            handleUnionValueChange(Type.SIGNATURE, oldValue, this.signature);
        }

        @Override
        public final Builder signature(String signature) {
            Object oldValue = this.signature;
            this.signature = signature;
            handleUnionValueChange(Type.SIGNATURE, oldValue, this.signature);
            return this;
        }

        @Override
        public ReasoningContentBlockDelta build() {
            return new ReasoningContentBlockDelta(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ReasoningContentBlockDelta#type()
     */
    public enum Type {
        TEXT,

        REDACTED_CONTENT,

        SIGNATURE,

        UNKNOWN_TO_SDK_VERSION
    }
}
