/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A content block stop event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ContentBlockStopEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentBlockStopEvent.Builder, ContentBlockStopEvent>, ConverseStreamOutput {
    private static final SdkField<Integer> CONTENT_BLOCK_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("contentBlockIndex").getter(getter(ContentBlockStopEvent::contentBlockIndex))
            .setter(setter(Builder::contentBlockIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentBlockIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_BLOCK_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer contentBlockIndex;

    protected ContentBlockStopEvent(BuilderImpl builder) {
        this.contentBlockIndex = builder.contentBlockIndex;
    }

    /**
     * <p>
     * The index for a content block.
     * </p>
     * 
     * @return The index for a content block.
     */
    public final Integer contentBlockIndex() {
        return contentBlockIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentBlockIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlockStopEvent)) {
            return false;
        }
        ContentBlockStopEvent other = (ContentBlockStopEvent) obj;
        return Objects.equals(contentBlockIndex(), other.contentBlockIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentBlockStopEvent").add("ContentBlockIndex", contentBlockIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentBlockIndex":
            return Optional.ofNullable(clazz.cast(contentBlockIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final ContentBlockStopEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contentBlockIndex", CONTENT_BLOCK_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBlockStopEvent, T> g) {
        return obj -> g.apply((ContentBlockStopEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link ContentBlockStopEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(ConverseStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentBlockStopEvent> {
        /**
         * <p>
         * The index for a content block.
         * </p>
         * 
         * @param contentBlockIndex
         *        The index for a content block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentBlockIndex(Integer contentBlockIndex);
    }

    protected static class BuilderImpl implements Builder {
        private Integer contentBlockIndex;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ContentBlockStopEvent model) {
            contentBlockIndex(model.contentBlockIndex);
        }

        public final Integer getContentBlockIndex() {
            return contentBlockIndex;
        }

        public final void setContentBlockIndex(Integer contentBlockIndex) {
            this.contentBlockIndex = contentBlockIndex;
        }

        @Override
        public final Builder contentBlockIndex(Integer contentBlockIndex) {
            this.contentBlockIndex = contentBlockIndex;
            return this;
        }

        @Override
        public ContentBlockStopEvent build() {
            return new ContentBlockStopEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
