/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeOutputDataConfig;
import software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AsyncInvokeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AsyncInvokeSummary> {
    private static final SdkField<String> INVOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationArn").getter(AsyncInvokeSummary.getter(AsyncInvokeSummary::invocationArn)).setter(AsyncInvokeSummary.setter(Builder::invocationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationArn").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(AsyncInvokeSummary.getter(AsyncInvokeSummary::modelArn)).setter(AsyncInvokeSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(AsyncInvokeSummary.getter(AsyncInvokeSummary::clientRequestToken)).setter(AsyncInvokeSummary.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AsyncInvokeSummary.getter(AsyncInvokeSummary::statusAsString)).setter(AsyncInvokeSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(AsyncInvokeSummary.getter(AsyncInvokeSummary::failureMessage)).setter(AsyncInvokeSummary.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("submitTime").getter(AsyncInvokeSummary.getter(AsyncInvokeSummary::submitTime)).setter(AsyncInvokeSummary.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(AsyncInvokeSummary.getter(AsyncInvokeSummary::lastModifiedTime)).setter(AsyncInvokeSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(AsyncInvokeSummary.getter(AsyncInvokeSummary::endTime)).setter(AsyncInvokeSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<AsyncInvokeOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(AsyncInvokeSummary.getter(AsyncInvokeSummary::outputDataConfig)).setter(AsyncInvokeSummary.setter(Builder::outputDataConfig)).constructor(AsyncInvokeOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_ARN_FIELD, MODEL_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, STATUS_FIELD, FAILURE_MESSAGE_FIELD, SUBMIT_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, OUTPUT_DATA_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("invocationArn", INVOCATION_ARN_FIELD);
            this.put("modelArn", MODEL_ARN_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("failureMessage", FAILURE_MESSAGE_FIELD);
            this.put("submitTime", SUBMIT_TIME_FIELD);
            this.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String invocationArn;
    private final String modelArn;
    private final String clientRequestToken;
    private final String status;
    private final String failureMessage;
    private final Instant submitTime;
    private final Instant lastModifiedTime;
    private final Instant endTime;
    private final AsyncInvokeOutputDataConfig outputDataConfig;

    private AsyncInvokeSummary(BuilderImpl builder) {
        this.invocationArn = builder.invocationArn;
        this.modelArn = builder.modelArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
        this.submitTime = builder.submitTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.outputDataConfig = builder.outputDataConfig;
    }

    public final String invocationArn() {
        return this.invocationArn;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final AsyncInvokeStatus status() {
        return AsyncInvokeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final Instant submitTime() {
        return this.submitTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final AsyncInvokeOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInvokeSummary)) {
            return false;
        }
        AsyncInvokeSummary other = (AsyncInvokeSummary)obj;
        return Objects.equals(this.invocationArn(), other.invocationArn()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AsyncInvokeSummary").add("InvocationArn", (Object)this.invocationArn()).add("ModelArn", (Object)this.modelArn()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Status", (Object)this.statusAsString()).add("FailureMessage", (Object)(this.failureMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("SubmitTime", (Object)this.submitTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("EndTime", (Object)this.endTime()).add("OutputDataConfig", (Object)this.outputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invocationArn": {
                return Optional.ofNullable(clazz.cast(this.invocationArn()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "submitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AsyncInvokeSummary, T> g) {
        return obj -> g.apply((AsyncInvokeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String invocationArn;
        private String modelArn;
        private String clientRequestToken;
        private String status;
        private String failureMessage;
        private Instant submitTime;
        private Instant lastModifiedTime;
        private Instant endTime;
        private AsyncInvokeOutputDataConfig outputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInvokeSummary model) {
            this.invocationArn(model.invocationArn);
            this.modelArn(model.modelArn);
            this.clientRequestToken(model.clientRequestToken);
            this.status(model.status);
            this.failureMessage(model.failureMessage);
            this.submitTime(model.submitTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.endTime(model.endTime);
            this.outputDataConfig(model.outputDataConfig);
        }

        public final String getInvocationArn() {
            return this.invocationArn;
        }

        public final void setInvocationArn(String invocationArn) {
            this.invocationArn = invocationArn;
        }

        @Override
        public final Builder invocationArn(String invocationArn) {
            this.invocationArn = invocationArn;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AsyncInvokeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final AsyncInvokeOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(AsyncInvokeOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(AsyncInvokeOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public AsyncInvokeSummary build() {
            return new AsyncInvokeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AsyncInvokeSummary> {
        public Builder invocationArn(String var1);

        public Builder modelArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder status(String var1);

        public Builder status(AsyncInvokeStatus var1);

        public Builder failureMessage(String var1);

        public Builder submitTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder outputDataConfig(AsyncInvokeOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<AsyncInvokeOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((AsyncInvokeOutputDataConfig)((AsyncInvokeOutputDataConfig.Builder)AsyncInvokeOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }
    }
}

