/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Top level guardrail trace object. For more information, see <a>ConverseTrace</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailTraceAssessment implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailTraceAssessment.Builder, GuardrailTraceAssessment> {
    private static final SdkField<List<String>> MODEL_OUTPUT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("modelOutput")
            .getter(getter(GuardrailTraceAssessment::modelOutput))
            .setter(setter(Builder::modelOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelOutput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, GuardrailAssessment>> INPUT_ASSESSMENT_FIELD = SdkField
            .<Map<String, GuardrailAssessment>> builder(MarshallingType.MAP)
            .memberName("inputAssessment")
            .getter(getter(GuardrailTraceAssessment::inputAssessment))
            .setter(setter(Builder::inputAssessment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAssessment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<GuardrailAssessment> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAssessment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<GuardrailAssessment>>> OUTPUT_ASSESSMENTS_FIELD = SdkField
            .<Map<String, List<GuardrailAssessment>>> builder(MarshallingType.MAP)
            .memberName("outputAssessments")
            .getter(getter(GuardrailTraceAssessment::outputAssessments))
            .setter(setter(Builder::outputAssessments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAssessments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<GuardrailAssessment>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<GuardrailAssessment> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(GuardrailAssessment::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_OUTPUT_FIELD,
            INPUT_ASSESSMENT_FIELD, OUTPUT_ASSESSMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> modelOutput;

    private final Map<String, GuardrailAssessment> inputAssessment;

    private final Map<String, List<GuardrailAssessment>> outputAssessments;

    private GuardrailTraceAssessment(BuilderImpl builder) {
        this.modelOutput = builder.modelOutput;
        this.inputAssessment = builder.inputAssessment;
        this.outputAssessments = builder.outputAssessments;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelOutput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelOutput() {
        return modelOutput != null && !(modelOutput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The output from the model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelOutput} method.
     * </p>
     * 
     * @return The output from the model.
     */
    public final List<String> modelOutput() {
        return modelOutput;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputAssessment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputAssessment() {
        return inputAssessment != null && !(inputAssessment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The input assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputAssessment} method.
     * </p>
     * 
     * @return The input assessment.
     */
    public final Map<String, GuardrailAssessment> inputAssessment() {
        return inputAssessment;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputAssessments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputAssessments() {
        return outputAssessments != null && !(outputAssessments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * the output assessments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputAssessments} method.
     * </p>
     * 
     * @return the output assessments.
     */
    public final Map<String, List<GuardrailAssessment>> outputAssessments() {
        return outputAssessments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasModelOutput() ? modelOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputAssessment() ? inputAssessment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputAssessments() ? outputAssessments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTraceAssessment)) {
            return false;
        }
        GuardrailTraceAssessment other = (GuardrailTraceAssessment) obj;
        return hasModelOutput() == other.hasModelOutput() && Objects.equals(modelOutput(), other.modelOutput())
                && hasInputAssessment() == other.hasInputAssessment()
                && Objects.equals(inputAssessment(), other.inputAssessment())
                && hasOutputAssessments() == other.hasOutputAssessments()
                && Objects.equals(outputAssessments(), other.outputAssessments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailTraceAssessment").add("ModelOutput", hasModelOutput() ? modelOutput() : null)
                .add("InputAssessment", hasInputAssessment() ? inputAssessment() : null)
                .add("OutputAssessments", hasOutputAssessments() ? outputAssessments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelOutput":
            return Optional.ofNullable(clazz.cast(modelOutput()));
        case "inputAssessment":
            return Optional.ofNullable(clazz.cast(inputAssessment()));
        case "outputAssessments":
            return Optional.ofNullable(clazz.cast(outputAssessments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTraceAssessment, T> g) {
        return obj -> g.apply((GuardrailTraceAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailTraceAssessment> {
        /**
         * <p>
         * The output from the model.
         * </p>
         * 
         * @param modelOutput
         *        The output from the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelOutput(Collection<String> modelOutput);

        /**
         * <p>
         * The output from the model.
         * </p>
         * 
         * @param modelOutput
         *        The output from the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelOutput(String... modelOutput);

        /**
         * <p>
         * The input assessment.
         * </p>
         * 
         * @param inputAssessment
         *        The input assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAssessment(Map<String, GuardrailAssessment> inputAssessment);

        /**
         * <p>
         * the output assessments.
         * </p>
         * 
         * @param outputAssessments
         *        the output assessments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputAssessments(Map<String, ? extends Collection<GuardrailAssessment>> outputAssessments);
    }

    static final class BuilderImpl implements Builder {
        private List<String> modelOutput = DefaultSdkAutoConstructList.getInstance();

        private Map<String, GuardrailAssessment> inputAssessment = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<GuardrailAssessment>> outputAssessments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTraceAssessment model) {
            modelOutput(model.modelOutput);
            inputAssessment(model.inputAssessment);
            outputAssessments(model.outputAssessments);
        }

        public final Collection<String> getModelOutput() {
            if (modelOutput instanceof SdkAutoConstructList) {
                return null;
            }
            return modelOutput;
        }

        public final void setModelOutput(Collection<String> modelOutput) {
            this.modelOutput = ModelOutputsCopier.copy(modelOutput);
        }

        @Override
        public final Builder modelOutput(Collection<String> modelOutput) {
            this.modelOutput = ModelOutputsCopier.copy(modelOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelOutput(String... modelOutput) {
            modelOutput(Arrays.asList(modelOutput));
            return this;
        }

        public final Map<String, GuardrailAssessment.Builder> getInputAssessment() {
            Map<String, GuardrailAssessment.Builder> result = GuardrailAssessmentMapCopier.copyToBuilder(this.inputAssessment);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputAssessment(Map<String, GuardrailAssessment.BuilderImpl> inputAssessment) {
            this.inputAssessment = GuardrailAssessmentMapCopier.copyFromBuilder(inputAssessment);
        }

        @Override
        public final Builder inputAssessment(Map<String, GuardrailAssessment> inputAssessment) {
            this.inputAssessment = GuardrailAssessmentMapCopier.copy(inputAssessment);
            return this;
        }

        public final Map<String, List<GuardrailAssessment.Builder>> getOutputAssessments() {
            Map<String, List<GuardrailAssessment.Builder>> result = GuardrailAssessmentListMapCopier
                    .copyToBuilder(this.outputAssessments);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOutputAssessments(
                Map<String, ? extends Collection<GuardrailAssessment.BuilderImpl>> outputAssessments) {
            this.outputAssessments = GuardrailAssessmentListMapCopier.copyFromBuilder(outputAssessments);
        }

        @Override
        public final Builder outputAssessments(Map<String, ? extends Collection<GuardrailAssessment>> outputAssessments) {
            this.outputAssessments = GuardrailAssessmentListMapCopier.copy(outputAssessments);
            return this;
        }

        @Override
        public GuardrailTraceAssessment build() {
            return new GuardrailTraceAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
