/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Personally Identifiable Information (PII) entity configured in a guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailPiiEntityFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailPiiEntityFilter.Builder, GuardrailPiiEntityFilter> {
    private static final SdkField<String> MATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("match")
            .getter(getter(GuardrailPiiEntityFilter::match)).setter(setter(Builder::match))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GuardrailPiiEntityFilter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailPiiEntityFilter::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_FIELD, TYPE_FIELD,
            ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String match;

    private final String type;

    private final String action;

    private GuardrailPiiEntityFilter(BuilderImpl builder) {
        this.match = builder.match;
        this.type = builder.type;
        this.action = builder.action;
    }

    /**
     * <p>
     * The PII entity filter match.
     * </p>
     * 
     * @return The PII entity filter match.
     */
    public final String match() {
        return match;
    }

    /**
     * <p>
     * The PII entity filter type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailPiiEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The PII entity filter type.
     * @see GuardrailPiiEntityType
     */
    public final GuardrailPiiEntityType type() {
        return GuardrailPiiEntityType.fromValue(type);
    }

    /**
     * <p>
     * The PII entity filter type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailPiiEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The PII entity filter type.
     * @see GuardrailPiiEntityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The PII entity filter action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationPolicyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The PII entity filter action.
     * @see GuardrailSensitiveInformationPolicyAction
     */
    public final GuardrailSensitiveInformationPolicyAction action() {
        return GuardrailSensitiveInformationPolicyAction.fromValue(action);
    }

    /**
     * <p>
     * The PII entity filter action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationPolicyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The PII entity filter action.
     * @see GuardrailSensitiveInformationPolicyAction
     */
    public final String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailPiiEntityFilter)) {
            return false;
        }
        GuardrailPiiEntityFilter other = (GuardrailPiiEntityFilter) obj;
        return Objects.equals(match(), other.match()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailPiiEntityFilter").add("Match", match()).add("Type", typeAsString())
                .add("Action", actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailPiiEntityFilter, T> g) {
        return obj -> g.apply((GuardrailPiiEntityFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailPiiEntityFilter> {
        /**
         * <p>
         * The PII entity filter match.
         * </p>
         * 
         * @param match
         *        The PII entity filter match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(String match);

        /**
         * <p>
         * The PII entity filter type.
         * </p>
         * 
         * @param type
         *        The PII entity filter type.
         * @see GuardrailPiiEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailPiiEntityType
         */
        Builder type(String type);

        /**
         * <p>
         * The PII entity filter type.
         * </p>
         * 
         * @param type
         *        The PII entity filter type.
         * @see GuardrailPiiEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailPiiEntityType
         */
        Builder type(GuardrailPiiEntityType type);

        /**
         * <p>
         * The PII entity filter action.
         * </p>
         * 
         * @param action
         *        The PII entity filter action.
         * @see GuardrailSensitiveInformationPolicyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationPolicyAction
         */
        Builder action(String action);

        /**
         * <p>
         * The PII entity filter action.
         * </p>
         * 
         * @param action
         *        The PII entity filter action.
         * @see GuardrailSensitiveInformationPolicyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationPolicyAction
         */
        Builder action(GuardrailSensitiveInformationPolicyAction action);
    }

    static final class BuilderImpl implements Builder {
        private String match;

        private String type;

        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailPiiEntityFilter model) {
            match(model.match);
            type(model.type);
            action(model.action);
        }

        public final String getMatch() {
            return match;
        }

        public final void setMatch(String match) {
            this.match = match;
        }

        @Override
        public final Builder match(String match) {
            this.match = match;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailPiiEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailSensitiveInformationPolicyAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public GuardrailPiiEntityFilter build() {
            return new GuardrailPiiEntityFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
