/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The trace object in a response from <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>.
 * Currently, you can only trace guardrails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConverseStreamTrace implements SdkPojo, Serializable,
        ToCopyableBuilder<ConverseStreamTrace.Builder, ConverseStreamTrace> {
    private static final SdkField<GuardrailTraceAssessment> GUARDRAIL_FIELD = SdkField
            .<GuardrailTraceAssessment> builder(MarshallingType.SDK_POJO).memberName("guardrail")
            .getter(getter(ConverseStreamTrace::guardrail)).setter(setter(Builder::guardrail))
            .constructor(GuardrailTraceAssessment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final GuardrailTraceAssessment guardrail;

    private ConverseStreamTrace(BuilderImpl builder) {
        this.guardrail = builder.guardrail;
    }

    /**
     * <p>
     * The guardrail trace object.
     * </p>
     * 
     * @return The guardrail trace object.
     */
    public final GuardrailTraceAssessment guardrail() {
        return guardrail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseStreamTrace)) {
            return false;
        }
        ConverseStreamTrace other = (ConverseStreamTrace) obj;
        return Objects.equals(guardrail(), other.guardrail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConverseStreamTrace").add("Guardrail", guardrail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrail":
            return Optional.ofNullable(clazz.cast(guardrail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConverseStreamTrace, T> g) {
        return obj -> g.apply((ConverseStreamTrace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConverseStreamTrace> {
        /**
         * <p>
         * The guardrail trace object.
         * </p>
         * 
         * @param guardrail
         *        The guardrail trace object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrail(GuardrailTraceAssessment guardrail);

        /**
         * <p>
         * The guardrail trace object.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailTraceAssessment.Builder}
         * avoiding the need to create one manually via {@link GuardrailTraceAssessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailTraceAssessment.Builder#build()} is called immediately
         * and its result is passed to {@link #guardrail(GuardrailTraceAssessment)}.
         * 
         * @param guardrail
         *        a consumer that will call methods on {@link GuardrailTraceAssessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrail(GuardrailTraceAssessment)
         */
        default Builder guardrail(Consumer<GuardrailTraceAssessment.Builder> guardrail) {
            return guardrail(GuardrailTraceAssessment.builder().applyMutation(guardrail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GuardrailTraceAssessment guardrail;

        private BuilderImpl() {
        }

        private BuilderImpl(ConverseStreamTrace model) {
            guardrail(model.guardrail);
        }

        public final GuardrailTraceAssessment.Builder getGuardrail() {
            return guardrail != null ? guardrail.toBuilder() : null;
        }

        public final void setGuardrail(GuardrailTraceAssessment.BuilderImpl guardrail) {
            this.guardrail = guardrail != null ? guardrail.build() : null;
        }

        @Override
        public final Builder guardrail(GuardrailTraceAssessment guardrail) {
            this.guardrail = guardrail;
            return this;
        }

        @Override
        public ConverseStreamTrace build() {
            return new ConverseStreamTrace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
