/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailConverseContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ImageBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentBlock> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ContentBlock.getter(ContentBlock::text)).setter(ContentBlock.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<ImageBlock> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("image").getter(ContentBlock.getter(ContentBlock::image)).setter(ContentBlock.setter(Builder::image)).constructor(ImageBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<DocumentBlock> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("document").getter(ContentBlock.getter(ContentBlock::document)).setter(ContentBlock.setter(Builder::document)).constructor(DocumentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<ToolUseBlock> TOOL_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolUse").getter(ContentBlock.getter(ContentBlock::toolUse)).setter(ContentBlock.setter(Builder::toolUse)).constructor(ToolUseBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUse").build()}).build();
    private static final SdkField<ToolResultBlock> TOOL_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolResult").getter(ContentBlock.getter(ContentBlock::toolResult)).setter(ContentBlock.setter(Builder::toolResult)).constructor(ToolResultBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolResult").build()}).build();
    private static final SdkField<GuardrailConverseContentBlock> GUARD_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardContent").getter(ContentBlock.getter(ContentBlock::guardContent)).setter(ContentBlock.setter(Builder::guardContent)).constructor(GuardrailConverseContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, IMAGE_FIELD, DOCUMENT_FIELD, TOOL_USE_FIELD, TOOL_RESULT_FIELD, GUARD_CONTENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String text;
    private final ImageBlock image;
    private final DocumentBlock document;
    private final ToolUseBlock toolUse;
    private final ToolResultBlock toolResult;
    private final GuardrailConverseContentBlock guardContent;
    private final Type type;

    private ContentBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.image = builder.image;
        this.document = builder.document;
        this.toolUse = builder.toolUse;
        this.toolResult = builder.toolResult;
        this.guardContent = builder.guardContent;
        this.type = builder.type;
    }

    public final String text() {
        return this.text;
    }

    public final ImageBlock image() {
        return this.image;
    }

    public final DocumentBlock document() {
        return this.document;
    }

    public final ToolUseBlock toolUse() {
        return this.toolUse;
    }

    public final ToolResultBlock toolResult() {
        return this.toolResult;
    }

    public final GuardrailConverseContentBlock guardContent() {
        return this.guardContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlock)) {
            return false;
        }
        ContentBlock other = (ContentBlock)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.document(), other.document()) && Objects.equals(this.toolUse(), other.toolUse()) && Objects.equals(this.toolResult(), other.toolResult()) && Objects.equals(this.guardContent(), other.guardContent());
    }

    public final String toString() {
        return ToString.builder((String)"ContentBlock").add("Text", (Object)this.text()).add("Image", (Object)this.image()).add("Document", (Object)this.document()).add("ToolUse", (Object)this.toolUse()).add("ToolResult", (Object)this.toolResult()).add("GuardContent", (Object)this.guardContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "toolUse": {
                return Optional.ofNullable(clazz.cast(this.toolUse()));
            }
            case "toolResult": {
                return Optional.ofNullable(clazz.cast(this.toolResult()));
            }
            case "guardContent": {
                return Optional.ofNullable(clazz.cast(this.guardContent()));
            }
        }
        return Optional.empty();
    }

    public static ContentBlock fromText(String text) {
        return (ContentBlock)ContentBlock.builder().text(text).build();
    }

    public static ContentBlock fromImage(ImageBlock image) {
        return (ContentBlock)ContentBlock.builder().image(image).build();
    }

    public static ContentBlock fromImage(Consumer<ImageBlock.Builder> image) {
        ImageBlock.Builder builder = ImageBlock.builder();
        image.accept(builder);
        return ContentBlock.fromImage((ImageBlock)builder.build());
    }

    public static ContentBlock fromDocument(DocumentBlock document) {
        return (ContentBlock)ContentBlock.builder().document(document).build();
    }

    public static ContentBlock fromDocument(Consumer<DocumentBlock.Builder> document) {
        DocumentBlock.Builder builder = DocumentBlock.builder();
        document.accept(builder);
        return ContentBlock.fromDocument((DocumentBlock)builder.build());
    }

    public static ContentBlock fromToolUse(ToolUseBlock toolUse) {
        return (ContentBlock)ContentBlock.builder().toolUse(toolUse).build();
    }

    public static ContentBlock fromToolUse(Consumer<ToolUseBlock.Builder> toolUse) {
        ToolUseBlock.Builder builder = ToolUseBlock.builder();
        toolUse.accept(builder);
        return ContentBlock.fromToolUse((ToolUseBlock)builder.build());
    }

    public static ContentBlock fromToolResult(ToolResultBlock toolResult) {
        return (ContentBlock)ContentBlock.builder().toolResult(toolResult).build();
    }

    public static ContentBlock fromToolResult(Consumer<ToolResultBlock.Builder> toolResult) {
        ToolResultBlock.Builder builder = ToolResultBlock.builder();
        toolResult.accept(builder);
        return ContentBlock.fromToolResult((ToolResultBlock)builder.build());
    }

    public static ContentBlock fromGuardContent(GuardrailConverseContentBlock guardContent) {
        return (ContentBlock)ContentBlock.builder().guardContent(guardContent).build();
    }

    public static ContentBlock fromGuardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
        GuardrailConverseContentBlock.Builder builder = GuardrailConverseContentBlock.builder();
        guardContent.accept(builder);
        return ContentBlock.fromGuardContent((GuardrailConverseContentBlock)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentBlock, T> g) {
        return obj -> g.apply((ContentBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        IMAGE,
        DOCUMENT,
        TOOL_USE,
        TOOL_RESULT,
        GUARD_CONTENT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private ImageBlock image;
        private DocumentBlock document;
        private ToolUseBlock toolUse;
        private ToolResultBlock toolResult;
        private GuardrailConverseContentBlock guardContent;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlock model) {
            this.text(model.text);
            this.image(model.image);
            this.document(model.document);
            this.toolUse(model.toolUse);
            this.toolResult(model.toolResult);
            this.guardContent(model.guardContent);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ImageBlock.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(ImageBlock.BuilderImpl image) {
            ImageBlock oldValue = this.image;
            this.image = image != null ? image.build() : null;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(ImageBlock image) {
            ImageBlock oldValue = this.image;
            this.image = image;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        public final DocumentBlock.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(DocumentBlock.BuilderImpl document) {
            DocumentBlock oldValue = this.document;
            this.document = document != null ? document.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
        }

        @Override
        public final Builder document(DocumentBlock document) {
            DocumentBlock oldValue = this.document;
            this.document = document;
            this.handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
            return this;
        }

        public final ToolUseBlock.Builder getToolUse() {
            return this.toolUse != null ? this.toolUse.toBuilder() : null;
        }

        public final void setToolUse(ToolUseBlock.BuilderImpl toolUse) {
            ToolUseBlock oldValue = this.toolUse;
            this.toolUse = toolUse != null ? toolUse.build() : null;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
        }

        @Override
        public final Builder toolUse(ToolUseBlock toolUse) {
            ToolUseBlock oldValue = this.toolUse;
            this.toolUse = toolUse;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
            return this;
        }

        public final ToolResultBlock.Builder getToolResult() {
            return this.toolResult != null ? this.toolResult.toBuilder() : null;
        }

        public final void setToolResult(ToolResultBlock.BuilderImpl toolResult) {
            ToolResultBlock oldValue = this.toolResult;
            this.toolResult = toolResult != null ? toolResult.build() : null;
            this.handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
        }

        @Override
        public final Builder toolResult(ToolResultBlock toolResult) {
            ToolResultBlock oldValue = this.toolResult;
            this.toolResult = toolResult;
            this.handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
            return this;
        }

        public final GuardrailConverseContentBlock.Builder getGuardContent() {
            return this.guardContent != null ? this.guardContent.toBuilder() : null;
        }

        public final void setGuardContent(GuardrailConverseContentBlock.BuilderImpl guardContent) {
            GuardrailConverseContentBlock oldValue = this.guardContent;
            this.guardContent = guardContent != null ? guardContent.build() : null;
            this.handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
        }

        @Override
        public final Builder guardContent(GuardrailConverseContentBlock guardContent) {
            GuardrailConverseContentBlock oldValue = this.guardContent;
            this.guardContent = guardContent;
            this.handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
            return this;
        }

        public ContentBlock build() {
            return new ContentBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentBlock> {
        public Builder text(String var1);

        public Builder image(ImageBlock var1);

        default public Builder image(Consumer<ImageBlock.Builder> image) {
            return this.image((ImageBlock)((ImageBlock.Builder)ImageBlock.builder().applyMutation(image)).build());
        }

        public Builder document(DocumentBlock var1);

        default public Builder document(Consumer<DocumentBlock.Builder> document) {
            return this.document((DocumentBlock)((DocumentBlock.Builder)DocumentBlock.builder().applyMutation(document)).build());
        }

        public Builder toolUse(ToolUseBlock var1);

        default public Builder toolUse(Consumer<ToolUseBlock.Builder> toolUse) {
            return this.toolUse((ToolUseBlock)((ToolUseBlock.Builder)ToolUseBlock.builder().applyMutation(toolUse)).build());
        }

        public Builder toolResult(ToolResultBlock var1);

        default public Builder toolResult(Consumer<ToolResultBlock.Builder> toolResult) {
            return this.toolResult((ToolResultBlock)((ToolResultBlock.Builder)ToolResultBlock.builder().applyMutation(toolResult)).build());
        }

        public Builder guardContent(GuardrailConverseContentBlock var1);

        default public Builder guardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
            return this.guardContent((GuardrailConverseContentBlock)((GuardrailConverseContentBlock.Builder)GuardrailConverseContentBlock.builder().applyMutation(guardContent)).build());
        }
    }
}

