/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeModelWithResponseStreamResponse extends BedrockRuntimeResponse implements
        ToCopyableBuilder<InvokeModelWithResponseStreamResponse.Builder, InvokeModelWithResponseStreamResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("contentType")
            .getter(getter(InvokeModelWithResponseStreamResponse::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-Content-Type").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD));

    private final String contentType;

    private InvokeModelWithResponseStreamResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The MIME type of the inference result.
     * </p>
     * 
     * @return The MIME type of the inference result.
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeModelWithResponseStreamResponse)) {
            return false;
        }
        InvokeModelWithResponseStreamResponse other = (InvokeModelWithResponseStreamResponse) obj;
        return Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeModelWithResponseStreamResponse").add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeModelWithResponseStreamResponse, T> g) {
        return obj -> g.apply((InvokeModelWithResponseStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeModelWithResponseStreamResponse> {
        /**
         * <p>
         * The MIME type of the inference result.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the inference result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl extends BedrockRuntimeResponse.BuilderImpl implements Builder {
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeModelWithResponseStreamResponse model) {
            super(model);
            contentType(model.contentType);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public InvokeModelWithResponseStreamResponse build() {
            return new InvokeModelWithResponseStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
