/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SemanticModality {
    DOCUMENT("DOCUMENT"),
    IMAGE("IMAGE"),
    AUDIO("AUDIO"),
    VIDEO("VIDEO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SemanticModality> VALUE_MAP;
    private final String value;

    private SemanticModality(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SemanticModality fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SemanticModality> knownValues() {
        EnumSet<SemanticModality> knownValues = EnumSet.allOf(SemanticModality.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SemanticModality.class, SemanticModality::toString);
    }
}

