/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.AssetProcessingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputConfiguration> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(InputConfiguration.getter(InputConfiguration::s3Uri)).setter(InputConfiguration.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final SdkField<AssetProcessingConfiguration> ASSET_PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetProcessingConfiguration").getter(InputConfiguration.getter(InputConfiguration::assetProcessingConfiguration)).setter(InputConfiguration.setter(Builder::assetProcessingConfiguration)).constructor(AssetProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProcessingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, ASSET_PROCESSING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final AssetProcessingConfiguration assetProcessingConfiguration;

    private InputConfiguration(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.assetProcessingConfiguration = builder.assetProcessingConfiguration;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final AssetProcessingConfiguration assetProcessingConfiguration() {
        return this.assetProcessingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetProcessingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfiguration)) {
            return false;
        }
        InputConfiguration other = (InputConfiguration)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.assetProcessingConfiguration(), other.assetProcessingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"InputConfiguration").add("S3Uri", (Object)this.s3Uri()).add("AssetProcessingConfiguration", (Object)this.assetProcessingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "assetProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.assetProcessingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3Uri", S3_URI_FIELD);
        map.put("assetProcessingConfiguration", ASSET_PROCESSING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputConfiguration, T> g) {
        return obj -> g.apply((InputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private AssetProcessingConfiguration assetProcessingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfiguration model) {
            this.s3Uri(model.s3Uri);
            this.assetProcessingConfiguration(model.assetProcessingConfiguration);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final AssetProcessingConfiguration.Builder getAssetProcessingConfiguration() {
            return this.assetProcessingConfiguration != null ? this.assetProcessingConfiguration.toBuilder() : null;
        }

        public final void setAssetProcessingConfiguration(AssetProcessingConfiguration.BuilderImpl assetProcessingConfiguration) {
            this.assetProcessingConfiguration = assetProcessingConfiguration != null ? assetProcessingConfiguration.build() : null;
        }

        @Override
        public final Builder assetProcessingConfiguration(AssetProcessingConfiguration assetProcessingConfiguration) {
            this.assetProcessingConfiguration = assetProcessingConfiguration;
            return this;
        }

        public InputConfiguration build() {
            return new InputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputConfiguration> {
        public Builder s3Uri(String var1);

        public Builder assetProcessingConfiguration(AssetProcessingConfiguration var1);

        default public Builder assetProcessingConfiguration(Consumer<AssetProcessingConfiguration.Builder> assetProcessingConfiguration) {
            return this.assetProcessingConfiguration((AssetProcessingConfiguration)((AssetProcessingConfiguration.Builder)AssetProcessingConfiguration.builder().applyMutation(assetProcessingConfiguration)).build());
        }
    }
}

