/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.BedrockDataAutomationRuntimeRequest;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.Blueprint;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.BlueprintListCopier;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.DataAutomationConfiguration;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.EncryptionConfiguration;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.InputConfiguration;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.NotificationConfiguration;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.OutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeDataAutomationAsyncRequest
extends BedrockDataAutomationRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeDataAutomationAsyncRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(InvokeDataAutomationAsyncRequest.getter(InvokeDataAutomationAsyncRequest::clientToken)).setter(InvokeDataAutomationAsyncRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<InputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputConfiguration").getter(InvokeDataAutomationAsyncRequest.getter(InvokeDataAutomationAsyncRequest::inputConfiguration)).setter(InvokeDataAutomationAsyncRequest.setter(Builder::inputConfiguration)).constructor(InputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build()}).build();
    private static final SdkField<OutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfiguration").getter(InvokeDataAutomationAsyncRequest.getter(InvokeDataAutomationAsyncRequest::outputConfiguration)).setter(InvokeDataAutomationAsyncRequest.setter(Builder::outputConfiguration)).constructor(OutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<DataAutomationConfiguration> DATA_AUTOMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataAutomationConfiguration").getter(InvokeDataAutomationAsyncRequest.getter(InvokeDataAutomationAsyncRequest::dataAutomationConfiguration)).setter(InvokeDataAutomationAsyncRequest.setter(Builder::dataAutomationConfiguration)).constructor(DataAutomationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAutomationConfiguration").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(InvokeDataAutomationAsyncRequest.getter(InvokeDataAutomationAsyncRequest::encryptionConfiguration)).setter(InvokeDataAutomationAsyncRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("notificationConfiguration").getter(InvokeDataAutomationAsyncRequest.getter(InvokeDataAutomationAsyncRequest::notificationConfiguration)).setter(InvokeDataAutomationAsyncRequest.setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfiguration").build()}).build();
    private static final SdkField<List<Blueprint>> BLUEPRINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blueprints").getter(InvokeDataAutomationAsyncRequest.getter(InvokeDataAutomationAsyncRequest::blueprints)).setter(InvokeDataAutomationAsyncRequest.setter(Builder::blueprints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Blueprint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, INPUT_CONFIGURATION_FIELD, OUTPUT_CONFIGURATION_FIELD, DATA_AUTOMATION_CONFIGURATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, NOTIFICATION_CONFIGURATION_FIELD, BLUEPRINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("inputConfiguration", INPUT_CONFIGURATION_FIELD);
            this.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
            this.put("dataAutomationConfiguration", DATA_AUTOMATION_CONFIGURATION_FIELD);
            this.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
            this.put("notificationConfiguration", NOTIFICATION_CONFIGURATION_FIELD);
            this.put("blueprints", BLUEPRINTS_FIELD);
        }
    });
    private final String clientToken;
    private final InputConfiguration inputConfiguration;
    private final OutputConfiguration outputConfiguration;
    private final DataAutomationConfiguration dataAutomationConfiguration;
    private final EncryptionConfiguration encryptionConfiguration;
    private final NotificationConfiguration notificationConfiguration;
    private final List<Blueprint> blueprints;

    private InvokeDataAutomationAsyncRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.inputConfiguration = builder.inputConfiguration;
        this.outputConfiguration = builder.outputConfiguration;
        this.dataAutomationConfiguration = builder.dataAutomationConfiguration;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.blueprints = builder.blueprints;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final InputConfiguration inputConfiguration() {
        return this.inputConfiguration;
    }

    public final OutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public final DataAutomationConfiguration dataAutomationConfiguration() {
        return this.dataAutomationConfiguration;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public final boolean hasBlueprints() {
        return this.blueprints != null && !(this.blueprints instanceof SdkAutoConstructList);
    }

    public final List<Blueprint> blueprints() {
        return this.blueprints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAutomationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlueprints() ? this.blueprints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeDataAutomationAsyncRequest)) {
            return false;
        }
        InvokeDataAutomationAsyncRequest other = (InvokeDataAutomationAsyncRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.inputConfiguration(), other.inputConfiguration()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.dataAutomationConfiguration(), other.dataAutomationConfiguration()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration()) && this.hasBlueprints() == other.hasBlueprints() && Objects.equals(this.blueprints(), other.blueprints());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeDataAutomationAsyncRequest").add("ClientToken", (Object)this.clientToken()).add("InputConfiguration", (Object)this.inputConfiguration()).add("OutputConfiguration", (Object)this.outputConfiguration()).add("DataAutomationConfiguration", (Object)this.dataAutomationConfiguration()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("NotificationConfiguration", (Object)this.notificationConfiguration()).add("Blueprints", this.hasBlueprints() ? this.blueprints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "inputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputConfiguration()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "dataAutomationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataAutomationConfiguration()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "notificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationConfiguration()));
            }
            case "blueprints": {
                return Optional.ofNullable(clazz.cast(this.blueprints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvokeDataAutomationAsyncRequest, T> g) {
        return obj -> g.apply((InvokeDataAutomationAsyncRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRuntimeRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private InputConfiguration inputConfiguration;
        private OutputConfiguration outputConfiguration;
        private DataAutomationConfiguration dataAutomationConfiguration;
        private EncryptionConfiguration encryptionConfiguration;
        private NotificationConfiguration notificationConfiguration;
        private List<Blueprint> blueprints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeDataAutomationAsyncRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.inputConfiguration(model.inputConfiguration);
            this.outputConfiguration(model.outputConfiguration);
            this.dataAutomationConfiguration(model.dataAutomationConfiguration);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.notificationConfiguration(model.notificationConfiguration);
            this.blueprints(model.blueprints);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final InputConfiguration.Builder getInputConfiguration() {
            return this.inputConfiguration != null ? this.inputConfiguration.toBuilder() : null;
        }

        public final void setInputConfiguration(InputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        @Override
        public final Builder inputConfiguration(InputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final OutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(OutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(OutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final DataAutomationConfiguration.Builder getDataAutomationConfiguration() {
            return this.dataAutomationConfiguration != null ? this.dataAutomationConfiguration.toBuilder() : null;
        }

        public final void setDataAutomationConfiguration(DataAutomationConfiguration.BuilderImpl dataAutomationConfiguration) {
            this.dataAutomationConfiguration = dataAutomationConfiguration != null ? dataAutomationConfiguration.build() : null;
        }

        @Override
        public final Builder dataAutomationConfiguration(DataAutomationConfiguration dataAutomationConfiguration) {
            this.dataAutomationConfiguration = dataAutomationConfiguration;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final List<Blueprint.Builder> getBlueprints() {
            List<Blueprint.Builder> result = BlueprintListCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<Blueprint.BuilderImpl> blueprints) {
            this.blueprints = BlueprintListCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<Blueprint> blueprints) {
            this.blueprints = BlueprintListCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Blueprint ... blueprints) {
            this.blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<Blueprint.Builder> ... blueprints) {
            this.blueprints(Stream.of(blueprints).map(c -> (Blueprint)((Blueprint.Builder)Blueprint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeDataAutomationAsyncRequest build() {
            return new InvokeDataAutomationAsyncRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockDataAutomationRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeDataAutomationAsyncRequest> {
        public Builder clientToken(String var1);

        public Builder inputConfiguration(InputConfiguration var1);

        default public Builder inputConfiguration(Consumer<InputConfiguration.Builder> inputConfiguration) {
            return this.inputConfiguration((InputConfiguration)((InputConfiguration.Builder)InputConfiguration.builder().applyMutation(inputConfiguration)).build());
        }

        public Builder outputConfiguration(OutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<OutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((OutputConfiguration)((OutputConfiguration.Builder)OutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder dataAutomationConfiguration(DataAutomationConfiguration var1);

        default public Builder dataAutomationConfiguration(Consumer<DataAutomationConfiguration.Builder> dataAutomationConfiguration) {
            return this.dataAutomationConfiguration((DataAutomationConfiguration)((DataAutomationConfiguration.Builder)DataAutomationConfiguration.builder().applyMutation(dataAutomationConfiguration)).build());
        }

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().applyMutation(notificationConfiguration)).build());
        }

        public Builder blueprints(Collection<Blueprint> var1);

        public Builder blueprints(Blueprint ... var1);

        public Builder blueprints(Consumer<Blueprint.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

