/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.DocumentOutputAdditionalFileFormat;
import software.amazon.awssdk.services.bedrockdataautomation.model.DocumentOutputTextFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentOutputFormat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentOutputFormat> {
    private static final SdkField<DocumentOutputTextFormat> TEXT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("textFormat").getter(DocumentOutputFormat.getter(DocumentOutputFormat::textFormat)).setter(DocumentOutputFormat.setter(Builder::textFormat)).constructor(DocumentOutputTextFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textFormat").build()}).build();
    private static final SdkField<DocumentOutputAdditionalFileFormat> ADDITIONAL_FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("additionalFileFormat").getter(DocumentOutputFormat.getter(DocumentOutputFormat::additionalFileFormat)).setter(DocumentOutputFormat.setter(Builder::additionalFileFormat)).constructor(DocumentOutputAdditionalFileFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalFileFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FORMAT_FIELD, ADDITIONAL_FILE_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentOutputFormat.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DocumentOutputTextFormat textFormat;
    private final DocumentOutputAdditionalFileFormat additionalFileFormat;

    private DocumentOutputFormat(BuilderImpl builder) {
        this.textFormat = builder.textFormat;
        this.additionalFileFormat = builder.additionalFileFormat;
    }

    public final DocumentOutputTextFormat textFormat() {
        return this.textFormat;
    }

    public final DocumentOutputAdditionalFileFormat additionalFileFormat() {
        return this.additionalFileFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalFileFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentOutputFormat)) {
            return false;
        }
        DocumentOutputFormat other = (DocumentOutputFormat)obj;
        return Objects.equals(this.textFormat(), other.textFormat()) && Objects.equals(this.additionalFileFormat(), other.additionalFileFormat());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentOutputFormat").add("TextFormat", (Object)this.textFormat()).add("AdditionalFileFormat", (Object)this.additionalFileFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "textFormat": {
                return Optional.ofNullable(clazz.cast(this.textFormat()));
            }
            case "additionalFileFormat": {
                return Optional.ofNullable(clazz.cast(this.additionalFileFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("textFormat", TEXT_FORMAT_FIELD);
        map.put("additionalFileFormat", ADDITIONAL_FILE_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentOutputFormat, T> g) {
        return obj -> g.apply((DocumentOutputFormat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DocumentOutputTextFormat textFormat;
        private DocumentOutputAdditionalFileFormat additionalFileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentOutputFormat model) {
            this.textFormat(model.textFormat);
            this.additionalFileFormat(model.additionalFileFormat);
        }

        public final DocumentOutputTextFormat.Builder getTextFormat() {
            return this.textFormat != null ? this.textFormat.toBuilder() : null;
        }

        public final void setTextFormat(DocumentOutputTextFormat.BuilderImpl textFormat) {
            this.textFormat = textFormat != null ? textFormat.build() : null;
        }

        @Override
        public final Builder textFormat(DocumentOutputTextFormat textFormat) {
            this.textFormat = textFormat;
            return this;
        }

        public final DocumentOutputAdditionalFileFormat.Builder getAdditionalFileFormat() {
            return this.additionalFileFormat != null ? this.additionalFileFormat.toBuilder() : null;
        }

        public final void setAdditionalFileFormat(DocumentOutputAdditionalFileFormat.BuilderImpl additionalFileFormat) {
            this.additionalFileFormat = additionalFileFormat != null ? additionalFileFormat.build() : null;
        }

        @Override
        public final Builder additionalFileFormat(DocumentOutputAdditionalFileFormat additionalFileFormat) {
            this.additionalFileFormat = additionalFileFormat;
            return this;
        }

        public DocumentOutputFormat build() {
            return new DocumentOutputFormat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentOutputFormat> {
        public Builder textFormat(DocumentOutputTextFormat var1);

        default public Builder textFormat(Consumer<DocumentOutputTextFormat.Builder> textFormat) {
            return this.textFormat((DocumentOutputTextFormat)((DocumentOutputTextFormat.Builder)DocumentOutputTextFormat.builder().applyMutation(textFormat)).build());
        }

        public Builder additionalFileFormat(DocumentOutputAdditionalFileFormat var1);

        default public Builder additionalFileFormat(Consumer<DocumentOutputAdditionalFileFormat.Builder> additionalFileFormat) {
            return this.additionalFileFormat((DocumentOutputAdditionalFileFormat)((DocumentOutputAdditionalFileFormat.Builder)DocumentOutputAdditionalFileFormat.builder().applyMutation(additionalFileFormat)).build());
        }
    }
}

