/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.AudioStandardOutputConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.DocumentStandardOutputConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.ImageStandardOutputConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.VideoStandardOutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StandardOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StandardOutputConfiguration> {
    private static final SdkField<DocumentStandardOutputConfiguration> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("document").getter(StandardOutputConfiguration.getter(StandardOutputConfiguration::document)).setter(StandardOutputConfiguration.setter(Builder::document)).constructor(DocumentStandardOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<ImageStandardOutputConfiguration> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("image").getter(StandardOutputConfiguration.getter(StandardOutputConfiguration::image)).setter(StandardOutputConfiguration.setter(Builder::image)).constructor(ImageStandardOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<VideoStandardOutputConfiguration> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("video").getter(StandardOutputConfiguration.getter(StandardOutputConfiguration::video)).setter(StandardOutputConfiguration.setter(Builder::video)).constructor(VideoStandardOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()}).build();
    private static final SdkField<AudioStandardOutputConfiguration> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audio").getter(StandardOutputConfiguration.getter(StandardOutputConfiguration::audio)).setter(StandardOutputConfiguration.setter(Builder::audio)).constructor(AudioStandardOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, IMAGE_FIELD, VIDEO_FIELD, AUDIO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StandardOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DocumentStandardOutputConfiguration document;
    private final ImageStandardOutputConfiguration image;
    private final VideoStandardOutputConfiguration video;
    private final AudioStandardOutputConfiguration audio;

    private StandardOutputConfiguration(BuilderImpl builder) {
        this.document = builder.document;
        this.image = builder.image;
        this.video = builder.video;
        this.audio = builder.audio;
    }

    public final DocumentStandardOutputConfiguration document() {
        return this.document;
    }

    public final ImageStandardOutputConfiguration image() {
        return this.image;
    }

    public final VideoStandardOutputConfiguration video() {
        return this.video;
    }

    public final AudioStandardOutputConfiguration audio() {
        return this.audio;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.audio());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardOutputConfiguration)) {
            return false;
        }
        StandardOutputConfiguration other = (StandardOutputConfiguration)obj;
        return Objects.equals(this.document(), other.document()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.video(), other.video()) && Objects.equals(this.audio(), other.audio());
    }

    public final String toString() {
        return ToString.builder((String)"StandardOutputConfiguration").add("Document", (Object)this.document()).add("Image", (Object)this.image()).add("Video", (Object)this.video()).add("Audio", (Object)this.audio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "audio": {
                return Optional.ofNullable(clazz.cast(this.audio()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("document", DOCUMENT_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("video", VIDEO_FIELD);
        map.put("audio", AUDIO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardOutputConfiguration, T> g) {
        return obj -> g.apply((StandardOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DocumentStandardOutputConfiguration document;
        private ImageStandardOutputConfiguration image;
        private VideoStandardOutputConfiguration video;
        private AudioStandardOutputConfiguration audio;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardOutputConfiguration model) {
            this.document(model.document);
            this.image(model.image);
            this.video(model.video);
            this.audio(model.audio);
        }

        public final DocumentStandardOutputConfiguration.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(DocumentStandardOutputConfiguration.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(DocumentStandardOutputConfiguration document) {
            this.document = document;
            return this;
        }

        public final ImageStandardOutputConfiguration.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(ImageStandardOutputConfiguration.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(ImageStandardOutputConfiguration image) {
            this.image = image;
            return this;
        }

        public final VideoStandardOutputConfiguration.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(VideoStandardOutputConfiguration.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoStandardOutputConfiguration video) {
            this.video = video;
            return this;
        }

        public final AudioStandardOutputConfiguration.Builder getAudio() {
            return this.audio != null ? this.audio.toBuilder() : null;
        }

        public final void setAudio(AudioStandardOutputConfiguration.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioStandardOutputConfiguration audio) {
            this.audio = audio;
            return this;
        }

        public StandardOutputConfiguration build() {
            return new StandardOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StandardOutputConfiguration> {
        public Builder document(DocumentStandardOutputConfiguration var1);

        default public Builder document(Consumer<DocumentStandardOutputConfiguration.Builder> document) {
            return this.document((DocumentStandardOutputConfiguration)((DocumentStandardOutputConfiguration.Builder)DocumentStandardOutputConfiguration.builder().applyMutation(document)).build());
        }

        public Builder image(ImageStandardOutputConfiguration var1);

        default public Builder image(Consumer<ImageStandardOutputConfiguration.Builder> image) {
            return this.image((ImageStandardOutputConfiguration)((ImageStandardOutputConfiguration.Builder)ImageStandardOutputConfiguration.builder().applyMutation(image)).build());
        }

        public Builder video(VideoStandardOutputConfiguration var1);

        default public Builder video(Consumer<VideoStandardOutputConfiguration.Builder> video) {
            return this.video((VideoStandardOutputConfiguration)((VideoStandardOutputConfiguration.Builder)VideoStandardOutputConfiguration.builder().applyMutation(video)).build());
        }

        public Builder audio(AudioStandardOutputConfiguration var1);

        default public Builder audio(Consumer<AudioStandardOutputConfiguration.Builder> audio) {
            return this.audio((AudioStandardOutputConfiguration)((AudioStandardOutputConfiguration.Builder)AudioStandardOutputConfiguration.builder().applyMutation(audio)).build());
        }
    }
}

