/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockdataautomation.BedrockDataAutomationClient;
import software.amazon.awssdk.services.bedrockdataautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintSummary;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListBlueprintsResponse;

public class ListBlueprintsIterable
implements SdkIterable<ListBlueprintsResponse> {
    private final BedrockDataAutomationClient client;
    private final ListBlueprintsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBlueprintsIterable(BedrockDataAutomationClient client, ListBlueprintsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBlueprintsResponseFetcher();
    }

    public Iterator<ListBlueprintsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BlueprintSummary> blueprints() {
        Function<ListBlueprintsResponse, Iterator> getIterator = response -> {
            if (response != null && response.blueprints() != null) {
                return response.blueprints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBlueprintsResponseFetcher
    implements SyncPageFetcher<ListBlueprintsResponse> {
        private ListBlueprintsResponseFetcher() {
        }

        public boolean hasNextPage(ListBlueprintsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBlueprintsResponse nextPage(ListBlueprintsResponse previousPage) {
            if (previousPage == null) {
                return ListBlueprintsIterable.this.client.listBlueprints(ListBlueprintsIterable.this.firstRequest);
            }
            return ListBlueprintsIterable.this.client.listBlueprints((ListBlueprintsRequest)((Object)ListBlueprintsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

