/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeInputSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeInputSource> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(NodeInputSource.getter(NodeInputSource::expression)).setter(NodeInputSource.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(NodeInputSource.getter(NodeInputSource::nodeName)).setter(NodeInputSource.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<String> OUTPUT_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputFieldName").getter(NodeInputSource.getter(NodeInputSource::outputFieldName)).setter(NodeInputSource.setter(Builder::outputFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFieldName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, NODE_NAME_FIELD, OUTPUT_FIELD_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeInputSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final String nodeName;
    private final String outputFieldName;

    private NodeInputSource(BuilderImpl builder) {
        this.expression = builder.expression;
        this.nodeName = builder.nodeName;
        this.outputFieldName = builder.outputFieldName;
    }

    public final String expression() {
        return this.expression;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final String outputFieldName() {
        return this.outputFieldName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFieldName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInputSource)) {
            return false;
        }
        NodeInputSource other = (NodeInputSource)obj;
        return Objects.equals(this.expression(), other.expression()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.outputFieldName(), other.outputFieldName());
    }

    public final String toString() {
        return ToString.builder((String)"NodeInputSource").add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("NodeName", (Object)this.nodeName()).add("OutputFieldName", (Object)this.outputFieldName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "outputFieldName": {
                return Optional.ofNullable(clazz.cast(this.outputFieldName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("expression", EXPRESSION_FIELD);
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("outputFieldName", OUTPUT_FIELD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeInputSource, T> g) {
        return obj -> g.apply((NodeInputSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private String nodeName;
        private String outputFieldName;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInputSource model) {
            this.expression(model.expression);
            this.nodeName(model.nodeName);
            this.outputFieldName(model.outputFieldName);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getOutputFieldName() {
            return this.outputFieldName;
        }

        public final void setOutputFieldName(String outputFieldName) {
            this.outputFieldName = outputFieldName;
        }

        @Override
        public final Builder outputFieldName(String outputFieldName) {
            this.outputFieldName = outputFieldName;
            return this;
        }

        public NodeInputSource build() {
            return new NodeInputSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeInputSource> {
        public Builder expression(String var1);

        public Builder nodeName(String var1);

        public Builder outputFieldName(String var1);
    }
}

