/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model.retrieveandgeneratestreamresponseoutput;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateOutputEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseOutput;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateOutputEvent}
 * that represents the {@code RetrieveAndGenerateStreamResponseOutput$output} event. Do not use this class directly.
 * Instead, use the static builder methods on
 * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseOutput}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultOutput extends RetrieveAndGenerateOutputEvent {
    private static final long serialVersionUID = 1L;

    DefaultOutput(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(RetrieveAndGenerateStreamResponseHandler.Visitor visitor) {
        visitor.visitOutput(this);
    }

    @Override
    public RetrieveAndGenerateStreamResponseOutput.EventType sdkEventType() {
        return RetrieveAndGenerateStreamResponseOutput.EventType.OUTPUT;
    }

    public interface Builder extends RetrieveAndGenerateOutputEvent.Builder {
        @Override
        DefaultOutput build();
    }

    private static final class BuilderImpl extends RetrieveAndGenerateOutputEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultOutput event) {
            super(event);
        }

        @Override
        public DefaultOutput build() {
            return new DefaultOutput(this);
        }
    }
}
