/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model.retrieveandgeneratestreamresponseoutput;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockagentruntime.model.CitationEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseOutput;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockagentruntime.model.CitationEvent} that represents
 * the {@code RetrieveAndGenerateStreamResponseOutput$citation} event. Do not use this class directly. Instead, use the
 * static builder methods on
 * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseOutput}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultCitation extends CitationEvent {
    private static final long serialVersionUID = 1L;

    DefaultCitation(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(RetrieveAndGenerateStreamResponseHandler.Visitor visitor) {
        visitor.visitCitation(this);
    }

    @Override
    public RetrieveAndGenerateStreamResponseOutput.EventType sdkEventType() {
        return RetrieveAndGenerateStreamResponseOutput.EventType.CITATION;
    }

    public interface Builder extends CitationEvent.Builder {
        @Override
        DefaultCitation build();
    }

    private static final class BuilderImpl extends CitationEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultCitation event) {
            super(event);
        }

        @Override
        public DefaultCitation build() {
            return new DefaultCitation(this);
        }
    }
}
