/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model.inlineagentresponsestream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentResponseStream;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentTracePart;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentTracePart} that
 * represents the {@code InlineAgentResponseStream$trace} event. Do not use this class directly. Instead, use the static
 * builder methods on {@link software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentResponseStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultTrace extends InlineAgentTracePart {
    private static final long serialVersionUID = 1L;

    DefaultTrace(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(InvokeInlineAgentResponseHandler.Visitor visitor) {
        visitor.visitTrace(this);
    }

    @Override
    public InlineAgentResponseStream.EventType sdkEventType() {
        return InlineAgentResponseStream.EventType.TRACE;
    }

    public interface Builder extends InlineAgentTracePart.Builder {
        @Override
        DefaultTrace build();
    }

    private static final class BuilderImpl extends InlineAgentTracePart.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultTrace event) {
            super(event);
        }

        @Override
        public DefaultTrace build() {
            return new DefaultTrace(this);
        }
    }
}
