/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model.flowresponsestream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowOutputEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowResponseStream;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeFlowResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockagentruntime.model.FlowOutputEvent} that represents
 * the {@code FlowResponseStream$flowOutputEvent} event. Do not use this class directly. Instead, use the static builder
 * methods on {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowResponseStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultFlowOutputEvent extends FlowOutputEvent {
    private static final long serialVersionUID = 1L;

    DefaultFlowOutputEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(InvokeFlowResponseHandler.Visitor visitor) {
        visitor.visitFlowOutputEvent(this);
    }

    @Override
    public FlowResponseStream.EventType sdkEventType() {
        return FlowResponseStream.EventType.FLOW_OUTPUT_EVENT;
    }

    public interface Builder extends FlowOutputEvent.Builder {
        @Override
        DefaultFlowOutputEvent build();
    }

    private static final class BuilderImpl extends FlowOutputEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultFlowOutputEvent event) {
            super(event);
        }

        @Override
        public DefaultFlowOutputEvent build() {
            return new DefaultFlowOutputEvent(this);
        }
    }
}
