/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSessionResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<UpdateSessionResponse.Builder, UpdateSessionResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(UpdateSessionResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(UpdateSessionResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(UpdateSessionResponse::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(UpdateSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> SESSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionStatus").getter(getter(UpdateSessionResponse::sessionStatusAsString))
            .setter(setter(Builder::sessionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, SESSION_ARN_FIELD, SESSION_ID_FIELD, SESSION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String sessionArn;

    private final String sessionId;

    private final String sessionStatus;

    private UpdateSessionResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.sessionArn = builder.sessionArn;
        this.sessionId = builder.sessionId;
        this.sessionStatus = builder.sessionStatus;
    }

    /**
     * <p>
     * The timestamp for when the session was created.
     * </p>
     * 
     * @return The timestamp for when the session was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp for when the session was last modified.
     * </p>
     * 
     * @return The timestamp for when the session was last modified.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the session that was updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the session that was updated.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * The unique identifier of the session you updated.
     * </p>
     * 
     * @return The unique identifier of the session you updated.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The status of the session you updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sessionStatus}
     * will return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sessionStatusAsString}.
     * </p>
     * 
     * @return The status of the session you updated.
     * @see SessionStatus
     */
    public final SessionStatus sessionStatus() {
        return SessionStatus.fromValue(sessionStatus);
    }

    /**
     * <p>
     * The status of the session you updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sessionStatus}
     * will return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sessionStatusAsString}.
     * </p>
     * 
     * @return The status of the session you updated.
     * @see SessionStatus
     */
    public final String sessionStatusAsString() {
        return sessionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionResponse)) {
            return false;
        }
        UpdateSessionResponse other = (UpdateSessionResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(sessionArn(), other.sessionArn()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(sessionStatusAsString(), other.sessionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSessionResponse").add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("SessionArn", sessionArn()).add("SessionId", sessionId()).add("SessionStatus", sessionStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sessionStatus":
            return Optional.ofNullable(clazz.cast(sessionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionStatus", SESSION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionResponse, T> g) {
        return obj -> g.apply((UpdateSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSessionResponse> {
        /**
         * <p>
         * The timestamp for when the session was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp for when the session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp for when the session was last modified.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp for when the session was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the session that was updated.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the session that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * The unique identifier of the session you updated.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the session you updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The status of the session you updated.
         * </p>
         * 
         * @param sessionStatus
         *        The status of the session you updated.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder sessionStatus(String sessionStatus);

        /**
         * <p>
         * The status of the session you updated.
         * </p>
         * 
         * @param sessionStatus
         *        The status of the session you updated.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder sessionStatus(SessionStatus sessionStatus);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String sessionArn;

        private String sessionId;

        private String sessionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionResponse model) {
            super(model);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            sessionArn(model.sessionArn);
            sessionId(model.sessionId);
            sessionStatus(model.sessionStatus);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionStatus() {
            return sessionStatus;
        }

        public final void setSessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
        }

        @Override
        public final Builder sessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
            return this;
        }

        @Override
        public final Builder sessionStatus(SessionStatus sessionStatus) {
            this.sessionStatus(sessionStatus == null ? null : sessionStatus.toString());
            return this;
        }

        @Override
        public UpdateSessionResponse build() {
            return new UpdateSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
