/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a document to rerank. Choose the <code>type</code> to define and include the field that
 * corresponds to the type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RerankDocument implements SdkPojo, Serializable, ToCopyableBuilder<RerankDocument.Builder, RerankDocument> {
    private static final SdkField<Document> JSON_DOCUMENT_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("jsonDocument").getter(getter(RerankDocument::jsonDocument)).setter(setter(Builder::jsonDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonDocument").build()).build();

    private static final SdkField<RerankTextDocument> TEXT_DOCUMENT_FIELD = SdkField
            .<RerankTextDocument> builder(MarshallingType.SDK_POJO).memberName("textDocument")
            .getter(getter(RerankDocument::textDocument)).setter(setter(Builder::textDocument))
            .constructor(RerankTextDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textDocument").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RerankDocument::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_DOCUMENT_FIELD,
            TEXT_DOCUMENT_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Document jsonDocument;

    private final RerankTextDocument textDocument;

    private final String type;

    private RerankDocument(BuilderImpl builder) {
        this.jsonDocument = builder.jsonDocument;
        this.textDocument = builder.textDocument;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains a JSON document to rerank.
     * </p>
     * 
     * @return Contains a JSON document to rerank.
     */
    public final Document jsonDocument() {
        return jsonDocument;
    }

    /**
     * <p>
     * Contains information about a text document to rerank.
     * </p>
     * 
     * @return Contains information about a text document to rerank.
     */
    public final RerankTextDocument textDocument() {
        return textDocument;
    }

    /**
     * <p>
     * The type of document to rerank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RerankDocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of document to rerank.
     * @see RerankDocumentType
     */
    public final RerankDocumentType type() {
        return RerankDocumentType.fromValue(type);
    }

    /**
     * <p>
     * The type of document to rerank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RerankDocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of document to rerank.
     * @see RerankDocumentType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonDocument());
        hashCode = 31 * hashCode + Objects.hashCode(textDocument());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankDocument)) {
            return false;
        }
        RerankDocument other = (RerankDocument) obj;
        return Objects.equals(jsonDocument(), other.jsonDocument()) && Objects.equals(textDocument(), other.textDocument())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RerankDocument").add("JsonDocument", jsonDocument())
                .add("TextDocument", textDocument() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jsonDocument":
            return Optional.ofNullable(clazz.cast(jsonDocument()));
        case "textDocument":
            return Optional.ofNullable(clazz.cast(textDocument()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jsonDocument", JSON_DOCUMENT_FIELD);
        map.put("textDocument", TEXT_DOCUMENT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankDocument, T> g) {
        return obj -> g.apply((RerankDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RerankDocument> {
        /**
         * <p>
         * Contains a JSON document to rerank.
         * </p>
         * 
         * @param jsonDocument
         *        Contains a JSON document to rerank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonDocument(Document jsonDocument);

        /**
         * <p>
         * Contains information about a text document to rerank.
         * </p>
         * 
         * @param textDocument
         *        Contains information about a text document to rerank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textDocument(RerankTextDocument textDocument);

        /**
         * <p>
         * Contains information about a text document to rerank.
         * </p>
         * This is a convenience method that creates an instance of the {@link RerankTextDocument.Builder} avoiding the
         * need to create one manually via {@link RerankTextDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RerankTextDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #textDocument(RerankTextDocument)}.
         * 
         * @param textDocument
         *        a consumer that will call methods on {@link RerankTextDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textDocument(RerankTextDocument)
         */
        default Builder textDocument(Consumer<RerankTextDocument.Builder> textDocument) {
            return textDocument(RerankTextDocument.builder().applyMutation(textDocument).build());
        }

        /**
         * <p>
         * The type of document to rerank.
         * </p>
         * 
         * @param type
         *        The type of document to rerank.
         * @see RerankDocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RerankDocumentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of document to rerank.
         * </p>
         * 
         * @param type
         *        The type of document to rerank.
         * @see RerankDocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RerankDocumentType
         */
        Builder type(RerankDocumentType type);
    }

    static final class BuilderImpl implements Builder {
        private Document jsonDocument;

        private RerankTextDocument textDocument;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RerankDocument model) {
            jsonDocument(model.jsonDocument);
            textDocument(model.textDocument);
            type(model.type);
        }

        public final Document getJsonDocument() {
            return jsonDocument;
        }

        public final void setJsonDocument(Document jsonDocument) {
            this.jsonDocument = jsonDocument;
        }

        @Override
        public final Builder jsonDocument(Document jsonDocument) {
            this.jsonDocument = jsonDocument;
            return this;
        }

        public final RerankTextDocument.Builder getTextDocument() {
            return textDocument != null ? textDocument.toBuilder() : null;
        }

        public final void setTextDocument(RerankTextDocument.BuilderImpl textDocument) {
            this.textDocument = textDocument != null ? textDocument.build() : null;
        }

        @Override
        public final Builder textDocument(RerankTextDocument textDocument) {
            this.textDocument = textDocument;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RerankDocumentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RerankDocument build() {
            return new RerankDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
