/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains content regarding the reasoning that the foundation model made with respect to the content in the content
 * block. Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance the accuracy of its final
 * response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReasoningContentBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<ReasoningContentBlock.Builder, ReasoningContentBlock> {
    private static final SdkField<ReasoningTextBlock> REASONING_TEXT_FIELD = SdkField
            .<ReasoningTextBlock> builder(MarshallingType.SDK_POJO).memberName("reasoningText")
            .getter(getter(ReasoningContentBlock::reasoningText)).setter(setter(Builder::reasoningText))
            .constructor(ReasoningTextBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasoningText").build()).build();

    private static final SdkField<SdkBytes> REDACTED_CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("redactedContent").getter(getter(ReasoningContentBlock::redactedContent))
            .setter(setter(Builder::redactedContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redactedContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASONING_TEXT_FIELD,
            REDACTED_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReasoningTextBlock reasoningText;

    private final SdkBytes redactedContent;

    private final Type type;

    private ReasoningContentBlock(BuilderImpl builder) {
        this.reasoningText = builder.reasoningText;
        this.redactedContent = builder.redactedContent;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains information about the reasoning that the model used to return the content in the content block.
     * </p>
     * 
     * @return Contains information about the reasoning that the model used to return the content in the content block.
     */
    public final ReasoningTextBlock reasoningText() {
        return reasoningText;
    }

    /**
     * <p>
     * The content in the reasoning that was encrypted by the model provider for trust and safety reasons.
     * </p>
     * 
     * @return The content in the reasoning that was encrypted by the model provider for trust and safety reasons.
     */
    public final SdkBytes redactedContent() {
        return redactedContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reasoningText());
        hashCode = 31 * hashCode + Objects.hashCode(redactedContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReasoningContentBlock)) {
            return false;
        }
        ReasoningContentBlock other = (ReasoningContentBlock) obj;
        return Objects.equals(reasoningText(), other.reasoningText())
                && Objects.equals(redactedContent(), other.redactedContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReasoningContentBlock")
                .add("ReasoningText", reasoningText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RedactedContent", redactedContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reasoningText":
            return Optional.ofNullable(clazz.cast(reasoningText()));
        case "redactedContent":
            return Optional.ofNullable(clazz.cast(redactedContent()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #reasoningText()} initialized to the given value.
     *
     * <p>
     * Contains information about the reasoning that the model used to return the content in the content block.
     * </p>
     * 
     * @param reasoningText
     *        Contains information about the reasoning that the model used to return the content in the content block.
     */
    public static ReasoningContentBlock fromReasoningText(ReasoningTextBlock reasoningText) {
        return builder().reasoningText(reasoningText).build();
    }

    /**
     * Create an instance of this class with {@link #reasoningText()} initialized to the given value.
     *
     * <p>
     * Contains information about the reasoning that the model used to return the content in the content block.
     * </p>
     * 
     * @param reasoningText
     *        Contains information about the reasoning that the model used to return the content in the content block.
     */
    public static ReasoningContentBlock fromReasoningText(Consumer<ReasoningTextBlock.Builder> reasoningText) {
        ReasoningTextBlock.Builder builder = ReasoningTextBlock.builder();
        reasoningText.accept(builder);
        return fromReasoningText(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redactedContent()} initialized to the given value.
     *
     * <p>
     * The content in the reasoning that was encrypted by the model provider for trust and safety reasons.
     * </p>
     * 
     * @param redactedContent
     *        The content in the reasoning that was encrypted by the model provider for trust and safety reasons.
     */
    public static ReasoningContentBlock fromRedactedContent(SdkBytes redactedContent) {
        return builder().redactedContent(redactedContent).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reasoningText", REASONING_TEXT_FIELD);
        map.put("redactedContent", REDACTED_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReasoningContentBlock, T> g) {
        return obj -> g.apply((ReasoningContentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReasoningContentBlock> {
        /**
         * <p>
         * Contains information about the reasoning that the model used to return the content in the content block.
         * </p>
         * 
         * @param reasoningText
         *        Contains information about the reasoning that the model used to return the content in the content
         *        block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasoningText(ReasoningTextBlock reasoningText);

        /**
         * <p>
         * Contains information about the reasoning that the model used to return the content in the content block.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReasoningTextBlock.Builder} avoiding the
         * need to create one manually via {@link ReasoningTextBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReasoningTextBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #reasoningText(ReasoningTextBlock)}.
         * 
         * @param reasoningText
         *        a consumer that will call methods on {@link ReasoningTextBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reasoningText(ReasoningTextBlock)
         */
        default Builder reasoningText(Consumer<ReasoningTextBlock.Builder> reasoningText) {
            return reasoningText(ReasoningTextBlock.builder().applyMutation(reasoningText).build());
        }

        /**
         * <p>
         * The content in the reasoning that was encrypted by the model provider for trust and safety reasons.
         * </p>
         * 
         * @param redactedContent
         *        The content in the reasoning that was encrypted by the model provider for trust and safety reasons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redactedContent(SdkBytes redactedContent);
    }

    static final class BuilderImpl implements Builder {
        private ReasoningTextBlock reasoningText;

        private SdkBytes redactedContent;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReasoningContentBlock model) {
            reasoningText(model.reasoningText);
            redactedContent(model.redactedContent);
        }

        public final ReasoningTextBlock.Builder getReasoningText() {
            return reasoningText != null ? reasoningText.toBuilder() : null;
        }

        public final void setReasoningText(ReasoningTextBlock.BuilderImpl reasoningText) {
            Object oldValue = this.reasoningText;
            this.reasoningText = reasoningText != null ? reasoningText.build() : null;
            handleUnionValueChange(Type.REASONING_TEXT, oldValue, this.reasoningText);
        }

        @Override
        public final Builder reasoningText(ReasoningTextBlock reasoningText) {
            Object oldValue = this.reasoningText;
            this.reasoningText = reasoningText;
            handleUnionValueChange(Type.REASONING_TEXT, oldValue, this.reasoningText);
            return this;
        }

        public final ByteBuffer getRedactedContent() {
            return redactedContent == null ? null : redactedContent.asByteBuffer();
        }

        public final void setRedactedContent(ByteBuffer redactedContent) {
            redactedContent(redactedContent == null ? null : SdkBytes.fromByteBuffer(redactedContent));
        }

        @Override
        public final Builder redactedContent(SdkBytes redactedContent) {
            Object oldValue = this.redactedContent;
            this.redactedContent = redactedContent;
            handleUnionValueChange(Type.REDACTED_CONTENT, oldValue, this.redactedContent);
            return this;
        }

        @Override
        public ReasoningContentBlock build() {
            return new ReasoningContentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ReasoningContentBlock#type()
     */
    public enum Type {
        REASONING_TEXT,

        REDACTED_CONTENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
