/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvocationStepsRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<ListInvocationStepsRequest.Builder, ListInvocationStepsRequest> {
    private static final SdkField<String> INVOCATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationIdentifier").getter(getter(ListInvocationStepsRequest::invocationIdentifier))
            .setter(setter(Builder::invocationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationIdentifier").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListInvocationStepsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInvocationStepsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SESSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionIdentifier").getter(getter(ListInvocationStepsRequest::sessionIdentifier))
            .setter(setter(Builder::sessionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_IDENTIFIER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SESSION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String invocationIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String sessionIdentifier;

    private ListInvocationStepsRequest(BuilderImpl builder) {
        super(builder);
        this.invocationIdentifier = builder.invocationIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sessionIdentifier = builder.sessionIdentifier;
    }

    /**
     * <p>
     * The unique identifier (in UUID format) for the invocation to list invocation steps for.
     * </p>
     * 
     * @return The unique identifier (in UUID format) for the invocation to list invocation steps for.
     */
    public final String invocationIdentifier() {
        return invocationIdentifier;
    }

    /**
     * <p>
     * The maximum number of results to return in the response. If the total number of results is greater than this
     * value, use the token returned in the response in the <code>nextToken</code> field when making another request to
     * return the next batch of results.
     * </p>
     * 
     * @return The maximum number of results to return in the response. If the total number of results is greater than
     *         this value, use the token returned in the response in the <code>nextToken</code> field when making
     *         another request to return the next batch of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter
     * the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of
     * results.
     * </p>
     * 
     * @return If the total number of results is greater than the <code>maxResults</code> value provided in the request,
     *         enter the token returned in the <code>nextToken</code> field in the response in this field to return the
     *         next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The unique identifier for the session associated with the invocation steps. You can specify either the session's
     * <code>sessionId</code> or its Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The unique identifier for the session associated with the invocation steps. You can specify either the
     *         session's <code>sessionId</code> or its Amazon Resource Name (ARN).
     */
    public final String sessionIdentifier() {
        return sessionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invocationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sessionIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvocationStepsRequest)) {
            return false;
        }
        ListInvocationStepsRequest other = (ListInvocationStepsRequest) obj;
        return Objects.equals(invocationIdentifier(), other.invocationIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sessionIdentifier(), other.sessionIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvocationStepsRequest").add("InvocationIdentifier", invocationIdentifier())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("SessionIdentifier", sessionIdentifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationIdentifier":
            return Optional.ofNullable(clazz.cast(invocationIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sessionIdentifier":
            return Optional.ofNullable(clazz.cast(sessionIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationIdentifier", INVOCATION_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sessionIdentifier", SESSION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvocationStepsRequest, T> g) {
        return obj -> g.apply((ListInvocationStepsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInvocationStepsRequest> {
        /**
         * <p>
         * The unique identifier (in UUID format) for the invocation to list invocation steps for.
         * </p>
         * 
         * @param invocationIdentifier
         *        The unique identifier (in UUID format) for the invocation to list invocation steps for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationIdentifier(String invocationIdentifier);

        /**
         * <p>
         * The maximum number of results to return in the response. If the total number of results is greater than this
         * value, use the token returned in the response in the <code>nextToken</code> field when making another request
         * to return the next batch of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response. If the total number of results is greater
         *        than this value, use the token returned in the response in the <code>nextToken</code> field when
         *        making another request to return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the total number of results is greater than the <code>maxResults</code> value provided in the request,
         * enter the token returned in the <code>nextToken</code> field in the response in this field to return the next
         * batch of results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the <code>maxResults</code> value provided in the
         *        request, enter the token returned in the <code>nextToken</code> field in the response in this field to
         *        return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The unique identifier for the session associated with the invocation steps. You can specify either the
         * session's <code>sessionId</code> or its Amazon Resource Name (ARN).
         * </p>
         * 
         * @param sessionIdentifier
         *        The unique identifier for the session associated with the invocation steps. You can specify either the
         *        session's <code>sessionId</code> or its Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionIdentifier(String sessionIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String invocationIdentifier;

        private Integer maxResults;

        private String nextToken;

        private String sessionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvocationStepsRequest model) {
            super(model);
            invocationIdentifier(model.invocationIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sessionIdentifier(model.sessionIdentifier);
        }

        public final String getInvocationIdentifier() {
            return invocationIdentifier;
        }

        public final void setInvocationIdentifier(String invocationIdentifier) {
            this.invocationIdentifier = invocationIdentifier;
        }

        @Override
        public final Builder invocationIdentifier(String invocationIdentifier) {
            this.invocationIdentifier = invocationIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSessionIdentifier() {
            return sessionIdentifier;
        }

        public final void setSessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
        }

        @Override
        public final Builder sessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInvocationStepsRequest build() {
            return new ListInvocationStepsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
