/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeInlineAgentRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<InvokeInlineAgentRequest.Builder, InvokeInlineAgentRequest> {
    private static final SdkField<List<AgentActionGroup>> ACTION_GROUPS_FIELD = SdkField
            .<List<AgentActionGroup>> builder(MarshallingType.LIST)
            .memberName("actionGroups")
            .getter(getter(InvokeInlineAgentRequest::actionGroups))
            .setter(setter(Builder::actionGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentActionGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentActionGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGENT_COLLABORATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentCollaboration").getter(getter(InvokeInlineAgentRequest::agentCollaborationAsString))
            .setter(setter(Builder::agentCollaboration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboration").build())
            .build();

    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentName").getter(getter(InvokeInlineAgentRequest::agentName)).setter(setter(Builder::agentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()).build();

    private static final SdkField<InlineBedrockModelConfigurations> BEDROCK_MODEL_CONFIGURATIONS_FIELD = SdkField
            .<InlineBedrockModelConfigurations> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockModelConfigurations")
            .getter(getter(InvokeInlineAgentRequest::bedrockModelConfigurations))
            .setter(setter(Builder::bedrockModelConfigurations))
            .constructor(InlineBedrockModelConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelConfigurations").build())
            .build();

    private static final SdkField<List<CollaboratorConfiguration>> COLLABORATOR_CONFIGURATIONS_FIELD = SdkField
            .<List<CollaboratorConfiguration>> builder(MarshallingType.LIST)
            .memberName("collaboratorConfigurations")
            .getter(getter(InvokeInlineAgentRequest::collaboratorConfigurations))
            .setter(setter(Builder::collaboratorConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaboratorConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollaboratorConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Collaborator>> COLLABORATORS_FIELD = SdkField
            .<List<Collaborator>> builder(MarshallingType.LIST)
            .memberName("collaborators")
            .getter(getter(InvokeInlineAgentRequest::collaborators))
            .setter(setter(Builder::collaborators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Collaborator> builder(MarshallingType.SDK_POJO)
                                            .constructor(Collaborator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomOrchestration> CUSTOM_ORCHESTRATION_FIELD = SdkField
            .<CustomOrchestration> builder(MarshallingType.SDK_POJO).memberName("customOrchestration")
            .getter(getter(InvokeInlineAgentRequest::customOrchestration)).setter(setter(Builder::customOrchestration))
            .constructor(CustomOrchestration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOrchestration").build())
            .build();

    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyArn").getter(getter(InvokeInlineAgentRequest::customerEncryptionKeyArn))
            .setter(setter(Builder::customerEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build())
            .build();

    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableTrace").getter(getter(InvokeInlineAgentRequest::enableTrace)).setter(setter(Builder::enableTrace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()).build();

    private static final SdkField<Boolean> END_SESSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("endSession").getter(getter(InvokeInlineAgentRequest::endSession)).setter(setter(Builder::endSession))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endSession").build()).build();

    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("foundationModel").getter(getter(InvokeInlineAgentRequest::foundationModel))
            .setter(setter(Builder::foundationModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()).build();

    private static final SdkField<GuardrailConfigurationWithArn> GUARDRAIL_CONFIGURATION_FIELD = SdkField
            .<GuardrailConfigurationWithArn> builder(MarshallingType.SDK_POJO).memberName("guardrailConfiguration")
            .getter(getter(InvokeInlineAgentRequest::guardrailConfiguration)).setter(setter(Builder::guardrailConfiguration))
            .constructor(GuardrailConfigurationWithArn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build())
            .build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(InvokeInlineAgentRequest::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<InlineSessionState> INLINE_SESSION_STATE_FIELD = SdkField
            .<InlineSessionState> builder(MarshallingType.SDK_POJO).memberName("inlineSessionState")
            .getter(getter(InvokeInlineAgentRequest::inlineSessionState)).setter(setter(Builder::inlineSessionState))
            .constructor(InlineSessionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineSessionState").build())
            .build();

    private static final SdkField<String> INPUT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputText").getter(getter(InvokeInlineAgentRequest::inputText)).setter(setter(Builder::inputText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputText").build()).build();

    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instruction").getter(getter(InvokeInlineAgentRequest::instruction)).setter(setter(Builder::instruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()).build();

    private static final SdkField<List<KnowledgeBase>> KNOWLEDGE_BASES_FIELD = SdkField
            .<List<KnowledgeBase>> builder(MarshallingType.LIST)
            .memberName("knowledgeBases")
            .getter(getter(InvokeInlineAgentRequest::knowledgeBases))
            .setter(setter(Builder::knowledgeBases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KnowledgeBase> builder(MarshallingType.SDK_POJO)
                                            .constructor(KnowledgeBase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORCHESTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orchestrationType").getter(getter(InvokeInlineAgentRequest::orchestrationTypeAsString))
            .setter(setter(Builder::orchestrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationType").build()).build();

    private static final SdkField<PromptCreationConfigurations> PROMPT_CREATION_CONFIGURATIONS_FIELD = SdkField
            .<PromptCreationConfigurations> builder(MarshallingType.SDK_POJO)
            .memberName("promptCreationConfigurations")
            .getter(getter(InvokeInlineAgentRequest::promptCreationConfigurations))
            .setter(setter(Builder::promptCreationConfigurations))
            .constructor(PromptCreationConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptCreationConfigurations")
                    .build()).build();

    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<PromptOverrideConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("promptOverrideConfiguration")
            .getter(getter(InvokeInlineAgentRequest::promptOverrideConfiguration))
            .setter(setter(Builder::promptOverrideConfiguration))
            .constructor(PromptOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration")
                    .build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(InvokeInlineAgentRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<StreamingConfigurations> STREAMING_CONFIGURATIONS_FIELD = SdkField
            .<StreamingConfigurations> builder(MarshallingType.SDK_POJO).memberName("streamingConfigurations")
            .getter(getter(InvokeInlineAgentRequest::streamingConfigurations)).setter(setter(Builder::streamingConfigurations))
            .constructor(StreamingConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingConfigurations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUPS_FIELD,
            AGENT_COLLABORATION_FIELD, AGENT_NAME_FIELD, BEDROCK_MODEL_CONFIGURATIONS_FIELD, COLLABORATOR_CONFIGURATIONS_FIELD,
            COLLABORATORS_FIELD, CUSTOM_ORCHESTRATION_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, ENABLE_TRACE_FIELD,
            END_SESSION_FIELD, FOUNDATION_MODEL_FIELD, GUARDRAIL_CONFIGURATION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD,
            INLINE_SESSION_STATE_FIELD, INPUT_TEXT_FIELD, INSTRUCTION_FIELD, KNOWLEDGE_BASES_FIELD, ORCHESTRATION_TYPE_FIELD,
            PROMPT_CREATION_CONFIGURATIONS_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD, SESSION_ID_FIELD,
            STREAMING_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AgentActionGroup> actionGroups;

    private final String agentCollaboration;

    private final String agentName;

    private final InlineBedrockModelConfigurations bedrockModelConfigurations;

    private final List<CollaboratorConfiguration> collaboratorConfigurations;

    private final List<Collaborator> collaborators;

    private final CustomOrchestration customOrchestration;

    private final String customerEncryptionKeyArn;

    private final Boolean enableTrace;

    private final Boolean endSession;

    private final String foundationModel;

    private final GuardrailConfigurationWithArn guardrailConfiguration;

    private final Integer idleSessionTTLInSeconds;

    private final InlineSessionState inlineSessionState;

    private final String inputText;

    private final String instruction;

    private final List<KnowledgeBase> knowledgeBases;

    private final String orchestrationType;

    private final PromptCreationConfigurations promptCreationConfigurations;

    private final PromptOverrideConfiguration promptOverrideConfiguration;

    private final String sessionId;

    private final StreamingConfigurations streamingConfigurations;

    private InvokeInlineAgentRequest(BuilderImpl builder) {
        super(builder);
        this.actionGroups = builder.actionGroups;
        this.agentCollaboration = builder.agentCollaboration;
        this.agentName = builder.agentName;
        this.bedrockModelConfigurations = builder.bedrockModelConfigurations;
        this.collaboratorConfigurations = builder.collaboratorConfigurations;
        this.collaborators = builder.collaborators;
        this.customOrchestration = builder.customOrchestration;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.enableTrace = builder.enableTrace;
        this.endSession = builder.endSession;
        this.foundationModel = builder.foundationModel;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.inlineSessionState = builder.inlineSessionState;
        this.inputText = builder.inputText;
        this.instruction = builder.instruction;
        this.knowledgeBases = builder.knowledgeBases;
        this.orchestrationType = builder.orchestrationType;
        this.promptCreationConfigurations = builder.promptCreationConfigurations;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
        this.sessionId = builder.sessionId;
        this.streamingConfigurations = builder.streamingConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionGroups() {
        return actionGroups != null && !(actionGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of action groups with each action group defining the action the inline agent needs to carry out.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionGroups} method.
     * </p>
     * 
     * @return A list of action groups with each action group defining the action the inline agent needs to carry out.
     */
    public final List<AgentActionGroup> actionGroups() {
        return actionGroups;
    }

    /**
     * <p>
     * Defines how the inline collaborator agent handles information across multiple collaborator agents to coordinate a
     * final response. The inline collaborator agent can also be the supervisor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentCollaboration} will return {@link AgentCollaboration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #agentCollaborationAsString}.
     * </p>
     * 
     * @return Defines how the inline collaborator agent handles information across multiple collaborator agents to
     *         coordinate a final response. The inline collaborator agent can also be the supervisor.
     * @see AgentCollaboration
     */
    public final AgentCollaboration agentCollaboration() {
        return AgentCollaboration.fromValue(agentCollaboration);
    }

    /**
     * <p>
     * Defines how the inline collaborator agent handles information across multiple collaborator agents to coordinate a
     * final response. The inline collaborator agent can also be the supervisor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentCollaboration} will return {@link AgentCollaboration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #agentCollaborationAsString}.
     * </p>
     * 
     * @return Defines how the inline collaborator agent handles information across multiple collaborator agents to
     *         coordinate a final response. The inline collaborator agent can also be the supervisor.
     * @see AgentCollaboration
     */
    public final String agentCollaborationAsString() {
        return agentCollaboration;
    }

    /**
     * <p>
     * The name for the agent.
     * </p>
     * 
     * @return The name for the agent.
     */
    public final String agentName() {
        return agentName;
    }

    /**
     * <p>
     * Model settings for the request.
     * </p>
     * 
     * @return Model settings for the request.
     */
    public final InlineBedrockModelConfigurations bedrockModelConfigurations() {
        return bedrockModelConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollaboratorConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCollaboratorConfigurations() {
        return collaboratorConfigurations != null && !(collaboratorConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Settings for an inline agent collaborator called with <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html"
     * >InvokeInlineAgent</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollaboratorConfigurations} method.
     * </p>
     * 
     * @return Settings for an inline agent collaborator called with <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html"
     *         >InvokeInlineAgent</a>.
     */
    public final List<CollaboratorConfiguration> collaboratorConfigurations() {
        return collaboratorConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Collaborators property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCollaborators() {
        return collaborators != null && !(collaborators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of collaborator inline agents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollaborators} method.
     * </p>
     * 
     * @return List of collaborator inline agents.
     */
    public final List<Collaborator> collaborators() {
        return collaborators;
    }

    /**
     * <p>
     * Contains details of the custom orchestration configured for the agent.
     * </p>
     * 
     * @return Contains details of the custom orchestration configured for the agent.
     */
    public final CustomOrchestration customOrchestration() {
        return customOrchestration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use to encrypt your inline agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use to encrypt your inline agent.
     */
    public final String customerEncryptionKeyArn() {
        return customerEncryptionKeyArn;
    }

    /**
     * <p>
     * Specifies whether to turn on the trace or not to track the agent's reasoning process. For more information, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html">Using trace</a>.
     * </p>
     * 
     * @return Specifies whether to turn on the trace or not to track the agent's reasoning process. For more
     *         information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html">Using
     *         trace</a>.
     */
    public final Boolean enableTrace() {
        return enableTrace;
    }

    /**
     * <p>
     * Specifies whether to end the session with the inline agent or not.
     * </p>
     * 
     * @return Specifies whether to end the session with the inline agent or not.
     */
    public final Boolean endSession() {
        return endSession;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">model identifier
     * (ID)</a> of the model to use for orchestration by the inline agent. For example,
     * <code>meta.llama3-1-70b-instruct-v1:0</code>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">model
     *         identifier (ID)</a> of the model to use for orchestration by the inline agent. For example,
     *         <code>meta.llama3-1-70b-instruct-v1:0</code>.
     */
    public final String foundationModel() {
        return foundationModel;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to assign to
     * the inline agent.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to
     *         assign to the inline agent.
     */
    public final GuardrailConfigurationWithArn guardrailConfiguration() {
        return guardrailConfiguration;
    }

    /**
     * <p>
     * The number of seconds for which the inline agent should maintain session information. After this time expires,
     * the subsequent <code>InvokeInlineAgent</code> request begins a new session.
     * </p>
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time,
     * the session expires and the data provided before the timeout is deleted.
     * </p>
     * 
     * @return The number of seconds for which the inline agent should maintain session information. After this time
     *         expires, the subsequent <code>InvokeInlineAgent</code> request begins a new session. </p>
     *         <p>
     *         A user interaction remains active for the amount of time specified. If no conversation occurs during this
     *         time, the session expires and the data provided before the timeout is deleted.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * Parameters that specify the various attributes of a sessions. You can include attributes for the session or
     * prompt or, if you configured an action group to return control, results from invocation of the action group. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     * context</a>.
     * </p>
     * <note>
     * <p>
     * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     * <code>inputText</code> field will be ignored.
     * </p>
     * </note>
     * 
     * @return Parameters that specify the various attributes of a sessions. You can include attributes for the session
     *         or prompt or, if you configured an action group to return control, results from invocation of the action
     *         group. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     *         context</a>. </p> <note>
     *         <p>
     *         If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     *         <code>inputText</code> field will be ignored.
     *         </p>
     */
    public final InlineSessionState inlineSessionState() {
        return inlineSessionState;
    }

    /**
     * <p>
     * The prompt text to send to the agent.
     * </p>
     * <note>
     * <p>
     * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     * <code>inputText</code> field will be ignored.
     * </p>
     * </note>
     * 
     * @return The prompt text to send to the agent. </p> <note>
     *         <p>
     *         If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     *         <code>inputText</code> field will be ignored.
     *         </p>
     */
    public final String inputText() {
        return inputText;
    }

    /**
     * <p>
     * The instructions that tell the inline agent what it should do and how it should interact with users.
     * </p>
     * 
     * @return The instructions that tell the inline agent what it should do and how it should interact with users.
     */
    public final String instruction() {
        return instruction;
    }

    /**
     * For responses, this returns true if the service returned a value for the KnowledgeBases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKnowledgeBases() {
        return knowledgeBases != null && !(knowledgeBases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information of the knowledge bases to associate with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKnowledgeBases} method.
     * </p>
     * 
     * @return Contains information of the knowledge bases to associate with.
     */
    public final List<KnowledgeBase> knowledgeBases() {
        return knowledgeBases;
    }

    /**
     * <p>
     * Specifies the type of orchestration strategy for the agent. This is set to DEFAULT orchestration type, by
     * default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orchestrationType}
     * will return {@link OrchestrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orchestrationTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of orchestration strategy for the agent. This is set to DEFAULT orchestration type, by
     *         default.
     * @see OrchestrationType
     */
    public final OrchestrationType orchestrationType() {
        return OrchestrationType.fromValue(orchestrationType);
    }

    /**
     * <p>
     * Specifies the type of orchestration strategy for the agent. This is set to DEFAULT orchestration type, by
     * default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orchestrationType}
     * will return {@link OrchestrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #orchestrationTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of orchestration strategy for the agent. This is set to DEFAULT orchestration type, by
     *         default.
     * @see OrchestrationType
     */
    public final String orchestrationTypeAsString() {
        return orchestrationType;
    }

    /**
     * <p>
     * Specifies parameters that control how the service populates the agent prompt for an
     * <code>InvokeInlineAgent</code> request. You can control which aspects of previous invocations in the same agent
     * session the service uses to populate the agent prompt. This gives you more granular control over the contextual
     * history that is used to process the current request.
     * </p>
     * 
     * @return Specifies parameters that control how the service populates the agent prompt for an
     *         <code>InvokeInlineAgent</code> request. You can control which aspects of previous invocations in the same
     *         agent session the service uses to populate the agent prompt. This gives you more granular control over
     *         the contextual history that is used to process the current request.
     */
    public final PromptCreationConfigurations promptCreationConfigurations() {
        return promptCreationConfigurations;
    }

    /**
     * <p>
     * Configurations for advanced prompts used to override the default prompts to enhance the accuracy of the inline
     * agent.
     * </p>
     * 
     * @return Configurations for advanced prompts used to override the default prompts to enhance the accuracy of the
     *         inline agent.
     */
    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return promptOverrideConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the session. Use the same value across requests to continue the same conversation.
     * </p>
     * 
     * @return The unique identifier of the session. Use the same value across requests to continue the same
     *         conversation.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Specifies the configurations for streaming.
     * </p>
     * <note>
     * <p>
     * To use agent streaming, you need permissions to perform the <code>bedrock:InvokeModelWithResponseStream</code>
     * action.
     * </p>
     * </note>
     * 
     * @return Specifies the configurations for streaming. </p> <note>
     *         <p>
     *         To use agent streaming, you need permissions to perform the
     *         <code>bedrock:InvokeModelWithResponseStream</code> action.
     *         </p>
     */
    public final StreamingConfigurations streamingConfigurations() {
        return streamingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActionGroups() ? actionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(agentCollaborationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentName());
        hashCode = 31 * hashCode + Objects.hashCode(bedrockModelConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(hasCollaboratorConfigurations() ? collaboratorConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCollaborators() ? collaborators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customOrchestration());
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(enableTrace());
        hashCode = 31 * hashCode + Objects.hashCode(endSession());
        hashCode = 31 * hashCode + Objects.hashCode(foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(inlineSessionState());
        hashCode = 31 * hashCode + Objects.hashCode(inputText());
        hashCode = 31 * hashCode + Objects.hashCode(instruction());
        hashCode = 31 * hashCode + Objects.hashCode(hasKnowledgeBases() ? knowledgeBases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(orchestrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(promptCreationConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(promptOverrideConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(streamingConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeInlineAgentRequest)) {
            return false;
        }
        InvokeInlineAgentRequest other = (InvokeInlineAgentRequest) obj;
        return hasActionGroups() == other.hasActionGroups() && Objects.equals(actionGroups(), other.actionGroups())
                && Objects.equals(agentCollaborationAsString(), other.agentCollaborationAsString())
                && Objects.equals(agentName(), other.agentName())
                && Objects.equals(bedrockModelConfigurations(), other.bedrockModelConfigurations())
                && hasCollaboratorConfigurations() == other.hasCollaboratorConfigurations()
                && Objects.equals(collaboratorConfigurations(), other.collaboratorConfigurations())
                && hasCollaborators() == other.hasCollaborators() && Objects.equals(collaborators(), other.collaborators())
                && Objects.equals(customOrchestration(), other.customOrchestration())
                && Objects.equals(customerEncryptionKeyArn(), other.customerEncryptionKeyArn())
                && Objects.equals(enableTrace(), other.enableTrace()) && Objects.equals(endSession(), other.endSession())
                && Objects.equals(foundationModel(), other.foundationModel())
                && Objects.equals(guardrailConfiguration(), other.guardrailConfiguration())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(inlineSessionState(), other.inlineSessionState())
                && Objects.equals(inputText(), other.inputText()) && Objects.equals(instruction(), other.instruction())
                && hasKnowledgeBases() == other.hasKnowledgeBases() && Objects.equals(knowledgeBases(), other.knowledgeBases())
                && Objects.equals(orchestrationTypeAsString(), other.orchestrationTypeAsString())
                && Objects.equals(promptCreationConfigurations(), other.promptCreationConfigurations())
                && Objects.equals(promptOverrideConfiguration(), other.promptOverrideConfiguration())
                && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(streamingConfigurations(), other.streamingConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("InvokeInlineAgentRequest")
                .add("ActionGroups", hasActionGroups() ? actionGroups() : null)
                .add("AgentCollaboration", agentCollaborationAsString())
                .add("AgentName", agentName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BedrockModelConfigurations", bedrockModelConfigurations())
                .add("CollaboratorConfigurations", hasCollaboratorConfigurations() ? collaboratorConfigurations() : null)
                .add("Collaborators", hasCollaborators() ? collaborators() : null)
                .add("CustomOrchestration", customOrchestration())
                .add("CustomerEncryptionKeyArn", customerEncryptionKeyArn())
                .add("EnableTrace", enableTrace())
                .add("EndSession", endSession())
                .add("FoundationModel", foundationModel())
                .add("GuardrailConfiguration", guardrailConfiguration())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds())
                .add("InlineSessionState", inlineSessionState())
                .add("InputText", inputText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Instruction", instruction() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KnowledgeBases", hasKnowledgeBases() ? knowledgeBases() : null)
                .add("OrchestrationType", orchestrationTypeAsString())
                .add("PromptCreationConfigurations", promptCreationConfigurations())
                .add("PromptOverrideConfiguration",
                        promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SessionId", sessionId()).add("StreamingConfigurations", streamingConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroups":
            return Optional.ofNullable(clazz.cast(actionGroups()));
        case "agentCollaboration":
            return Optional.ofNullable(clazz.cast(agentCollaborationAsString()));
        case "agentName":
            return Optional.ofNullable(clazz.cast(agentName()));
        case "bedrockModelConfigurations":
            return Optional.ofNullable(clazz.cast(bedrockModelConfigurations()));
        case "collaboratorConfigurations":
            return Optional.ofNullable(clazz.cast(collaboratorConfigurations()));
        case "collaborators":
            return Optional.ofNullable(clazz.cast(collaborators()));
        case "customOrchestration":
            return Optional.ofNullable(clazz.cast(customOrchestration()));
        case "customerEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyArn()));
        case "enableTrace":
            return Optional.ofNullable(clazz.cast(enableTrace()));
        case "endSession":
            return Optional.ofNullable(clazz.cast(endSession()));
        case "foundationModel":
            return Optional.ofNullable(clazz.cast(foundationModel()));
        case "guardrailConfiguration":
            return Optional.ofNullable(clazz.cast(guardrailConfiguration()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "inlineSessionState":
            return Optional.ofNullable(clazz.cast(inlineSessionState()));
        case "inputText":
            return Optional.ofNullable(clazz.cast(inputText()));
        case "instruction":
            return Optional.ofNullable(clazz.cast(instruction()));
        case "knowledgeBases":
            return Optional.ofNullable(clazz.cast(knowledgeBases()));
        case "orchestrationType":
            return Optional.ofNullable(clazz.cast(orchestrationTypeAsString()));
        case "promptCreationConfigurations":
            return Optional.ofNullable(clazz.cast(promptCreationConfigurations()));
        case "promptOverrideConfiguration":
            return Optional.ofNullable(clazz.cast(promptOverrideConfiguration()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "streamingConfigurations":
            return Optional.ofNullable(clazz.cast(streamingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionGroups", ACTION_GROUPS_FIELD);
        map.put("agentCollaboration", AGENT_COLLABORATION_FIELD);
        map.put("agentName", AGENT_NAME_FIELD);
        map.put("bedrockModelConfigurations", BEDROCK_MODEL_CONFIGURATIONS_FIELD);
        map.put("collaboratorConfigurations", COLLABORATOR_CONFIGURATIONS_FIELD);
        map.put("collaborators", COLLABORATORS_FIELD);
        map.put("customOrchestration", CUSTOM_ORCHESTRATION_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        map.put("endSession", END_SESSION_FIELD);
        map.put("foundationModel", FOUNDATION_MODEL_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("inlineSessionState", INLINE_SESSION_STATE_FIELD);
        map.put("inputText", INPUT_TEXT_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("knowledgeBases", KNOWLEDGE_BASES_FIELD);
        map.put("orchestrationType", ORCHESTRATION_TYPE_FIELD);
        map.put("promptCreationConfigurations", PROMPT_CREATION_CONFIGURATIONS_FIELD);
        map.put("promptOverrideConfiguration", PROMPT_OVERRIDE_CONFIGURATION_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("streamingConfigurations", STREAMING_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeInlineAgentRequest, T> g) {
        return obj -> g.apply((InvokeInlineAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeInlineAgentRequest> {
        /**
         * <p>
         * A list of action groups with each action group defining the action the inline agent needs to carry out.
         * </p>
         * 
         * @param actionGroups
         *        A list of action groups with each action group defining the action the inline agent needs to carry
         *        out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroups(Collection<AgentActionGroup> actionGroups);

        /**
         * <p>
         * A list of action groups with each action group defining the action the inline agent needs to carry out.
         * </p>
         * 
         * @param actionGroups
         *        A list of action groups with each action group defining the action the inline agent needs to carry
         *        out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroups(AgentActionGroup... actionGroups);

        /**
         * <p>
         * A list of action groups with each action group defining the action the inline agent needs to carry out.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #actionGroups(List<AgentActionGroup>)}.
         * 
         * @param actionGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionGroups(java.util.Collection<AgentActionGroup>)
         */
        Builder actionGroups(Consumer<AgentActionGroup.Builder>... actionGroups);

        /**
         * <p>
         * Defines how the inline collaborator agent handles information across multiple collaborator agents to
         * coordinate a final response. The inline collaborator agent can also be the supervisor.
         * </p>
         * 
         * @param agentCollaboration
         *        Defines how the inline collaborator agent handles information across multiple collaborator agents to
         *        coordinate a final response. The inline collaborator agent can also be the supervisor.
         * @see AgentCollaboration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentCollaboration
         */
        Builder agentCollaboration(String agentCollaboration);

        /**
         * <p>
         * Defines how the inline collaborator agent handles information across multiple collaborator agents to
         * coordinate a final response. The inline collaborator agent can also be the supervisor.
         * </p>
         * 
         * @param agentCollaboration
         *        Defines how the inline collaborator agent handles information across multiple collaborator agents to
         *        coordinate a final response. The inline collaborator agent can also be the supervisor.
         * @see AgentCollaboration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentCollaboration
         */
        Builder agentCollaboration(AgentCollaboration agentCollaboration);

        /**
         * <p>
         * The name for the agent.
         * </p>
         * 
         * @param agentName
         *        The name for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentName(String agentName);

        /**
         * <p>
         * Model settings for the request.
         * </p>
         * 
         * @param bedrockModelConfigurations
         *        Model settings for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockModelConfigurations(InlineBedrockModelConfigurations bedrockModelConfigurations);

        /**
         * <p>
         * Model settings for the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link InlineBedrockModelConfigurations.Builder}
         * avoiding the need to create one manually via {@link InlineBedrockModelConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InlineBedrockModelConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #bedrockModelConfigurations(InlineBedrockModelConfigurations)}.
         * 
         * @param bedrockModelConfigurations
         *        a consumer that will call methods on {@link InlineBedrockModelConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockModelConfigurations(InlineBedrockModelConfigurations)
         */
        default Builder bedrockModelConfigurations(Consumer<InlineBedrockModelConfigurations.Builder> bedrockModelConfigurations) {
            return bedrockModelConfigurations(InlineBedrockModelConfigurations.builder()
                    .applyMutation(bedrockModelConfigurations).build());
        }

        /**
         * <p>
         * Settings for an inline agent collaborator called with <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html"
         * >InvokeInlineAgent</a>.
         * </p>
         * 
         * @param collaboratorConfigurations
         *        Settings for an inline agent collaborator called with <a href=
         *        "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html"
         *        >InvokeInlineAgent</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorConfigurations(Collection<CollaboratorConfiguration> collaboratorConfigurations);

        /**
         * <p>
         * Settings for an inline agent collaborator called with <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html"
         * >InvokeInlineAgent</a>.
         * </p>
         * 
         * @param collaboratorConfigurations
         *        Settings for an inline agent collaborator called with <a href=
         *        "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html"
         *        >InvokeInlineAgent</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorConfigurations(CollaboratorConfiguration... collaboratorConfigurations);

        /**
         * <p>
         * Settings for an inline agent collaborator called with <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html"
         * >InvokeInlineAgent</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #collaboratorConfigurations(List<CollaboratorConfiguration>)}.
         * 
         * @param collaboratorConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaboratorConfigurations(java.util.Collection<CollaboratorConfiguration>)
         */
        Builder collaboratorConfigurations(Consumer<CollaboratorConfiguration.Builder>... collaboratorConfigurations);

        /**
         * <p>
         * List of collaborator inline agents.
         * </p>
         * 
         * @param collaborators
         *        List of collaborator inline agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborators(Collection<Collaborator> collaborators);

        /**
         * <p>
         * List of collaborator inline agents.
         * </p>
         * 
         * @param collaborators
         *        List of collaborator inline agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborators(Collaborator... collaborators);

        /**
         * <p>
         * List of collaborator inline agents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Collaborator.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Collaborator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Collaborator.Builder#build()} is called
         * immediately and its result is passed to {@link #collaborators(List<Collaborator>)}.
         * 
         * @param collaborators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.Collaborator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborators(java.util.Collection<Collaborator>)
         */
        Builder collaborators(Consumer<Collaborator.Builder>... collaborators);

        /**
         * <p>
         * Contains details of the custom orchestration configured for the agent.
         * </p>
         * 
         * @param customOrchestration
         *        Contains details of the custom orchestration configured for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customOrchestration(CustomOrchestration customOrchestration);

        /**
         * <p>
         * Contains details of the custom orchestration configured for the agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomOrchestration.Builder} avoiding the
         * need to create one manually via {@link CustomOrchestration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomOrchestration.Builder#build()} is called immediately and
         * its result is passed to {@link #customOrchestration(CustomOrchestration)}.
         * 
         * @param customOrchestration
         *        a consumer that will call methods on {@link CustomOrchestration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customOrchestration(CustomOrchestration)
         */
        default Builder customOrchestration(Consumer<CustomOrchestration.Builder> customOrchestration) {
            return customOrchestration(CustomOrchestration.builder().applyMutation(customOrchestration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use to encrypt your inline agent.
         * </p>
         * 
         * @param customerEncryptionKeyArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use to encrypt your inline agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyArn(String customerEncryptionKeyArn);

        /**
         * <p>
         * Specifies whether to turn on the trace or not to track the agent's reasoning process. For more information,
         * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html">Using trace</a>.
         * </p>
         * 
         * @param enableTrace
         *        Specifies whether to turn on the trace or not to track the agent's reasoning process. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html">Using trace</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTrace(Boolean enableTrace);

        /**
         * <p>
         * Specifies whether to end the session with the inline agent or not.
         * </p>
         * 
         * @param endSession
         *        Specifies whether to end the session with the inline agent or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endSession(Boolean endSession);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">model
         * identifier (ID)</a> of the model to use for orchestration by the inline agent. For example,
         * <code>meta.llama3-1-70b-instruct-v1:0</code>.
         * </p>
         * 
         * @param foundationModel
         *        The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">model
         *        identifier (ID)</a> of the model to use for orchestration by the inline agent. For example,
         *        <code>meta.llama3-1-70b-instruct-v1:0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foundationModel(String foundationModel);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to assign
         * to the inline agent.
         * </p>
         * 
         * @param guardrailConfiguration
         *        The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to
         *        assign to the inline agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailConfiguration(GuardrailConfigurationWithArn guardrailConfiguration);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to assign
         * to the inline agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConfigurationWithArn.Builder}
         * avoiding the need to create one manually via {@link GuardrailConfigurationWithArn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConfigurationWithArn.Builder#build()} is called
         * immediately and its result is passed to {@link #guardrailConfiguration(GuardrailConfigurationWithArn)}.
         * 
         * @param guardrailConfiguration
         *        a consumer that will call methods on {@link GuardrailConfigurationWithArn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailConfiguration(GuardrailConfigurationWithArn)
         */
        default Builder guardrailConfiguration(Consumer<GuardrailConfigurationWithArn.Builder> guardrailConfiguration) {
            return guardrailConfiguration(GuardrailConfigurationWithArn.builder().applyMutation(guardrailConfiguration).build());
        }

        /**
         * <p>
         * The number of seconds for which the inline agent should maintain session information. After this time
         * expires, the subsequent <code>InvokeInlineAgent</code> request begins a new session.
         * </p>
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this
         * time, the session expires and the data provided before the timeout is deleted.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The number of seconds for which the inline agent should maintain session information. After this time
         *        expires, the subsequent <code>InvokeInlineAgent</code> request begins a new session. </p>
         *        <p>
         *        A user interaction remains active for the amount of time specified. If no conversation occurs during
         *        this time, the session expires and the data provided before the timeout is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * Parameters that specify the various attributes of a sessions. You can include attributes for the session or
         * prompt or, if you configured an action group to return control, results from invocation of the action group.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * <note>
         * <p>
         * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         * <code>inputText</code> field will be ignored.
         * </p>
         * </note>
         * 
         * @param inlineSessionState
         *        Parameters that specify the various attributes of a sessions. You can include attributes for the
         *        session or prompt or, if you configured an action group to return control, results from invocation of
         *        the action group. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         *        context</a>. </p> <note>
         *        <p>
         *        If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         *        <code>inputText</code> field will be ignored.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineSessionState(InlineSessionState inlineSessionState);

        /**
         * <p>
         * Parameters that specify the various attributes of a sessions. You can include attributes for the session or
         * prompt or, if you configured an action group to return control, results from invocation of the action group.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * <note>
         * <p>
         * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         * <code>inputText</code> field will be ignored.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link InlineSessionState.Builder}
         * avoiding the need to create one manually via {@link InlineSessionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InlineSessionState.Builder#build()} is called immediately and its
         * result is passed to {@link #inlineSessionState(InlineSessionState)}.
         * 
         * @param inlineSessionState
         *        a consumer that will call methods on {@link InlineSessionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineSessionState(InlineSessionState)
         */
        default Builder inlineSessionState(Consumer<InlineSessionState.Builder> inlineSessionState) {
            return inlineSessionState(InlineSessionState.builder().applyMutation(inlineSessionState).build());
        }

        /**
         * <p>
         * The prompt text to send to the agent.
         * </p>
         * <note>
         * <p>
         * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         * <code>inputText</code> field will be ignored.
         * </p>
         * </note>
         * 
         * @param inputText
         *        The prompt text to send to the agent. </p> <note>
         *        <p>
         *        If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         *        <code>inputText</code> field will be ignored.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputText(String inputText);

        /**
         * <p>
         * The instructions that tell the inline agent what it should do and how it should interact with users.
         * </p>
         * 
         * @param instruction
         *        The instructions that tell the inline agent what it should do and how it should interact with users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instruction(String instruction);

        /**
         * <p>
         * Contains information of the knowledge bases to associate with.
         * </p>
         * 
         * @param knowledgeBases
         *        Contains information of the knowledge bases to associate with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBases(Collection<KnowledgeBase> knowledgeBases);

        /**
         * <p>
         * Contains information of the knowledge bases to associate with.
         * </p>
         * 
         * @param knowledgeBases
         *        Contains information of the knowledge bases to associate with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBases(KnowledgeBase... knowledgeBases);

        /**
         * <p>
         * Contains information of the knowledge bases to associate with.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase.Builder#build()} is called
         * immediately and its result is passed to {@link #knowledgeBases(List<KnowledgeBase>)}.
         * 
         * @param knowledgeBases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBases(java.util.Collection<KnowledgeBase>)
         */
        Builder knowledgeBases(Consumer<KnowledgeBase.Builder>... knowledgeBases);

        /**
         * <p>
         * Specifies the type of orchestration strategy for the agent. This is set to DEFAULT orchestration type, by
         * default.
         * </p>
         * 
         * @param orchestrationType
         *        Specifies the type of orchestration strategy for the agent. This is set to DEFAULT orchestration type,
         *        by default.
         * @see OrchestrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrchestrationType
         */
        Builder orchestrationType(String orchestrationType);

        /**
         * <p>
         * Specifies the type of orchestration strategy for the agent. This is set to DEFAULT orchestration type, by
         * default.
         * </p>
         * 
         * @param orchestrationType
         *        Specifies the type of orchestration strategy for the agent. This is set to DEFAULT orchestration type,
         *        by default.
         * @see OrchestrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrchestrationType
         */
        Builder orchestrationType(OrchestrationType orchestrationType);

        /**
         * <p>
         * Specifies parameters that control how the service populates the agent prompt for an
         * <code>InvokeInlineAgent</code> request. You can control which aspects of previous invocations in the same
         * agent session the service uses to populate the agent prompt. This gives you more granular control over the
         * contextual history that is used to process the current request.
         * </p>
         * 
         * @param promptCreationConfigurations
         *        Specifies parameters that control how the service populates the agent prompt for an
         *        <code>InvokeInlineAgent</code> request. You can control which aspects of previous invocations in the
         *        same agent session the service uses to populate the agent prompt. This gives you more granular control
         *        over the contextual history that is used to process the current request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptCreationConfigurations(PromptCreationConfigurations promptCreationConfigurations);

        /**
         * <p>
         * Specifies parameters that control how the service populates the agent prompt for an
         * <code>InvokeInlineAgent</code> request. You can control which aspects of previous invocations in the same
         * agent session the service uses to populate the agent prompt. This gives you more granular control over the
         * contextual history that is used to process the current request.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptCreationConfigurations.Builder}
         * avoiding the need to create one manually via {@link PromptCreationConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptCreationConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #promptCreationConfigurations(PromptCreationConfigurations)}.
         * 
         * @param promptCreationConfigurations
         *        a consumer that will call methods on {@link PromptCreationConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptCreationConfigurations(PromptCreationConfigurations)
         */
        default Builder promptCreationConfigurations(Consumer<PromptCreationConfigurations.Builder> promptCreationConfigurations) {
            return promptCreationConfigurations(PromptCreationConfigurations.builder()
                    .applyMutation(promptCreationConfigurations).build());
        }

        /**
         * <p>
         * Configurations for advanced prompts used to override the default prompts to enhance the accuracy of the
         * inline agent.
         * </p>
         * 
         * @param promptOverrideConfiguration
         *        Configurations for advanced prompts used to override the default prompts to enhance the accuracy of
         *        the inline agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration);

        /**
         * <p>
         * Configurations for advanced prompts used to override the default prompts to enhance the accuracy of the
         * inline agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptOverrideConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #promptOverrideConfiguration(PromptOverrideConfiguration)}.
         * 
         * @param promptOverrideConfiguration
         *        a consumer that will call methods on {@link PromptOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptOverrideConfiguration(PromptOverrideConfiguration)
         */
        default Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return promptOverrideConfiguration(PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)
                    .build());
        }

        /**
         * <p>
         * The unique identifier of the session. Use the same value across requests to continue the same conversation.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the session. Use the same value across requests to continue the same
         *        conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Specifies the configurations for streaming.
         * </p>
         * <note>
         * <p>
         * To use agent streaming, you need permissions to perform the
         * <code>bedrock:InvokeModelWithResponseStream</code> action.
         * </p>
         * </note>
         * 
         * @param streamingConfigurations
         *        Specifies the configurations for streaming. </p> <note>
         *        <p>
         *        To use agent streaming, you need permissions to perform the
         *        <code>bedrock:InvokeModelWithResponseStream</code> action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingConfigurations(StreamingConfigurations streamingConfigurations);

        /**
         * <p>
         * Specifies the configurations for streaming.
         * </p>
         * <note>
         * <p>
         * To use agent streaming, you need permissions to perform the
         * <code>bedrock:InvokeModelWithResponseStream</code> action.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link StreamingConfigurations.Builder}
         * avoiding the need to create one manually via {@link StreamingConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamingConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #streamingConfigurations(StreamingConfigurations)}.
         * 
         * @param streamingConfigurations
         *        a consumer that will call methods on {@link StreamingConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingConfigurations(StreamingConfigurations)
         */
        default Builder streamingConfigurations(Consumer<StreamingConfigurations.Builder> streamingConfigurations) {
            return streamingConfigurations(StreamingConfigurations.builder().applyMutation(streamingConfigurations).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private List<AgentActionGroup> actionGroups = DefaultSdkAutoConstructList.getInstance();

        private String agentCollaboration;

        private String agentName;

        private InlineBedrockModelConfigurations bedrockModelConfigurations;

        private List<CollaboratorConfiguration> collaboratorConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<Collaborator> collaborators = DefaultSdkAutoConstructList.getInstance();

        private CustomOrchestration customOrchestration;

        private String customerEncryptionKeyArn;

        private Boolean enableTrace;

        private Boolean endSession;

        private String foundationModel;

        private GuardrailConfigurationWithArn guardrailConfiguration;

        private Integer idleSessionTTLInSeconds;

        private InlineSessionState inlineSessionState;

        private String inputText;

        private String instruction;

        private List<KnowledgeBase> knowledgeBases = DefaultSdkAutoConstructList.getInstance();

        private String orchestrationType;

        private PromptCreationConfigurations promptCreationConfigurations;

        private PromptOverrideConfiguration promptOverrideConfiguration;

        private String sessionId;

        private StreamingConfigurations streamingConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeInlineAgentRequest model) {
            super(model);
            actionGroups(model.actionGroups);
            agentCollaboration(model.agentCollaboration);
            agentName(model.agentName);
            bedrockModelConfigurations(model.bedrockModelConfigurations);
            collaboratorConfigurations(model.collaboratorConfigurations);
            collaborators(model.collaborators);
            customOrchestration(model.customOrchestration);
            customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            enableTrace(model.enableTrace);
            endSession(model.endSession);
            foundationModel(model.foundationModel);
            guardrailConfiguration(model.guardrailConfiguration);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            inlineSessionState(model.inlineSessionState);
            inputText(model.inputText);
            instruction(model.instruction);
            knowledgeBases(model.knowledgeBases);
            orchestrationType(model.orchestrationType);
            promptCreationConfigurations(model.promptCreationConfigurations);
            promptOverrideConfiguration(model.promptOverrideConfiguration);
            sessionId(model.sessionId);
            streamingConfigurations(model.streamingConfigurations);
        }

        public final List<AgentActionGroup.Builder> getActionGroups() {
            List<AgentActionGroup.Builder> result = AgentActionGroupsCopier.copyToBuilder(this.actionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionGroups(Collection<AgentActionGroup.BuilderImpl> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copyFromBuilder(actionGroups);
        }

        @Override
        public final Builder actionGroups(Collection<AgentActionGroup> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copy(actionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(AgentActionGroup... actionGroups) {
            actionGroups(Arrays.asList(actionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(Consumer<AgentActionGroup.Builder>... actionGroups) {
            actionGroups(Stream.of(actionGroups).map(c -> AgentActionGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAgentCollaboration() {
            return agentCollaboration;
        }

        public final void setAgentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
        }

        @Override
        public final Builder agentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
            return this;
        }

        @Override
        public final Builder agentCollaboration(AgentCollaboration agentCollaboration) {
            this.agentCollaboration(agentCollaboration == null ? null : agentCollaboration.toString());
            return this;
        }

        public final String getAgentName() {
            return agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final InlineBedrockModelConfigurations.Builder getBedrockModelConfigurations() {
            return bedrockModelConfigurations != null ? bedrockModelConfigurations.toBuilder() : null;
        }

        public final void setBedrockModelConfigurations(InlineBedrockModelConfigurations.BuilderImpl bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations != null ? bedrockModelConfigurations.build() : null;
        }

        @Override
        public final Builder bedrockModelConfigurations(InlineBedrockModelConfigurations bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations;
            return this;
        }

        public final List<CollaboratorConfiguration.Builder> getCollaboratorConfigurations() {
            List<CollaboratorConfiguration.Builder> result = CollaboratorConfigurationsCopier
                    .copyToBuilder(this.collaboratorConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaboratorConfigurations(
                Collection<CollaboratorConfiguration.BuilderImpl> collaboratorConfigurations) {
            this.collaboratorConfigurations = CollaboratorConfigurationsCopier.copyFromBuilder(collaboratorConfigurations);
        }

        @Override
        public final Builder collaboratorConfigurations(Collection<CollaboratorConfiguration> collaboratorConfigurations) {
            this.collaboratorConfigurations = CollaboratorConfigurationsCopier.copy(collaboratorConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaboratorConfigurations(CollaboratorConfiguration... collaboratorConfigurations) {
            collaboratorConfigurations(Arrays.asList(collaboratorConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaboratorConfigurations(Consumer<CollaboratorConfiguration.Builder>... collaboratorConfigurations) {
            collaboratorConfigurations(Stream.of(collaboratorConfigurations)
                    .map(c -> CollaboratorConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Collaborator.Builder> getCollaborators() {
            List<Collaborator.Builder> result = CollaboratorsCopier.copyToBuilder(this.collaborators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborators(Collection<Collaborator.BuilderImpl> collaborators) {
            this.collaborators = CollaboratorsCopier.copyFromBuilder(collaborators);
        }

        @Override
        public final Builder collaborators(Collection<Collaborator> collaborators) {
            this.collaborators = CollaboratorsCopier.copy(collaborators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborators(Collaborator... collaborators) {
            collaborators(Arrays.asList(collaborators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborators(Consumer<Collaborator.Builder>... collaborators) {
            collaborators(Stream.of(collaborators).map(c -> Collaborator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CustomOrchestration.Builder getCustomOrchestration() {
            return customOrchestration != null ? customOrchestration.toBuilder() : null;
        }

        public final void setCustomOrchestration(CustomOrchestration.BuilderImpl customOrchestration) {
            this.customOrchestration = customOrchestration != null ? customOrchestration.build() : null;
        }

        @Override
        public final Builder customOrchestration(CustomOrchestration customOrchestration) {
            this.customOrchestration = customOrchestration;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final Boolean getEnableTrace() {
            return enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        public final Boolean getEndSession() {
            return endSession;
        }

        public final void setEndSession(Boolean endSession) {
            this.endSession = endSession;
        }

        @Override
        public final Builder endSession(Boolean endSession) {
            this.endSession = endSession;
            return this;
        }

        public final String getFoundationModel() {
            return foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final GuardrailConfigurationWithArn.Builder getGuardrailConfiguration() {
            return guardrailConfiguration != null ? guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfigurationWithArn.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfigurationWithArn guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final InlineSessionState.Builder getInlineSessionState() {
            return inlineSessionState != null ? inlineSessionState.toBuilder() : null;
        }

        public final void setInlineSessionState(InlineSessionState.BuilderImpl inlineSessionState) {
            this.inlineSessionState = inlineSessionState != null ? inlineSessionState.build() : null;
        }

        @Override
        public final Builder inlineSessionState(InlineSessionState inlineSessionState) {
            this.inlineSessionState = inlineSessionState;
            return this;
        }

        public final String getInputText() {
            return inputText;
        }

        public final void setInputText(String inputText) {
            this.inputText = inputText;
        }

        @Override
        public final Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        public final String getInstruction() {
            return instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final List<KnowledgeBase.Builder> getKnowledgeBases() {
            List<KnowledgeBase.Builder> result = KnowledgeBasesCopier.copyToBuilder(this.knowledgeBases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKnowledgeBases(Collection<KnowledgeBase.BuilderImpl> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copyFromBuilder(knowledgeBases);
        }

        @Override
        public final Builder knowledgeBases(Collection<KnowledgeBase> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copy(knowledgeBases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(KnowledgeBase... knowledgeBases) {
            knowledgeBases(Arrays.asList(knowledgeBases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(Consumer<KnowledgeBase.Builder>... knowledgeBases) {
            knowledgeBases(Stream.of(knowledgeBases).map(c -> KnowledgeBase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOrchestrationType() {
            return orchestrationType;
        }

        public final void setOrchestrationType(String orchestrationType) {
            this.orchestrationType = orchestrationType;
        }

        @Override
        public final Builder orchestrationType(String orchestrationType) {
            this.orchestrationType = orchestrationType;
            return this;
        }

        @Override
        public final Builder orchestrationType(OrchestrationType orchestrationType) {
            this.orchestrationType(orchestrationType == null ? null : orchestrationType.toString());
            return this;
        }

        public final PromptCreationConfigurations.Builder getPromptCreationConfigurations() {
            return promptCreationConfigurations != null ? promptCreationConfigurations.toBuilder() : null;
        }

        public final void setPromptCreationConfigurations(PromptCreationConfigurations.BuilderImpl promptCreationConfigurations) {
            this.promptCreationConfigurations = promptCreationConfigurations != null ? promptCreationConfigurations.build()
                    : null;
        }

        @Override
        public final Builder promptCreationConfigurations(PromptCreationConfigurations promptCreationConfigurations) {
            this.promptCreationConfigurations = promptCreationConfigurations;
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return promptOverrideConfiguration != null ? promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final StreamingConfigurations.Builder getStreamingConfigurations() {
            return streamingConfigurations != null ? streamingConfigurations.toBuilder() : null;
        }

        public final void setStreamingConfigurations(StreamingConfigurations.BuilderImpl streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations != null ? streamingConfigurations.build() : null;
        }

        @Override
        public final Builder streamingConfigurations(StreamingConfigurations streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeInlineAgentRequest build() {
            return new InvokeInlineAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
