/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeAgentRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<InvokeAgentRequest.Builder, InvokeAgentRequest> {
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasId").getter(getter(InvokeAgentRequest::agentAliasId)).setter(setter(Builder::agentAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentAliasId").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(InvokeAgentRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<BedrockModelConfigurations> BEDROCK_MODEL_CONFIGURATIONS_FIELD = SdkField
            .<BedrockModelConfigurations> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockModelConfigurations")
            .getter(getter(InvokeAgentRequest::bedrockModelConfigurations))
            .setter(setter(Builder::bedrockModelConfigurations))
            .constructor(BedrockModelConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelConfigurations").build())
            .build();

    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableTrace").getter(getter(InvokeAgentRequest::enableTrace)).setter(setter(Builder::enableTrace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()).build();

    private static final SdkField<Boolean> END_SESSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("endSession").getter(getter(InvokeAgentRequest::endSession)).setter(setter(Builder::endSession))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endSession").build()).build();

    private static final SdkField<String> INPUT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputText").getter(getter(InvokeAgentRequest::inputText)).setter(setter(Builder::inputText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputText").build()).build();

    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryId").getter(getter(InvokeAgentRequest::memoryId)).setter(setter(Builder::memoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryId").build()).build();

    private static final SdkField<PromptCreationConfigurations> PROMPT_CREATION_CONFIGURATIONS_FIELD = SdkField
            .<PromptCreationConfigurations> builder(MarshallingType.SDK_POJO)
            .memberName("promptCreationConfigurations")
            .getter(getter(InvokeAgentRequest::promptCreationConfigurations))
            .setter(setter(Builder::promptCreationConfigurations))
            .constructor(PromptCreationConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptCreationConfigurations")
                    .build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(InvokeAgentRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.<SessionState> builder(MarshallingType.SDK_POJO)
            .memberName("sessionState").getter(getter(InvokeAgentRequest::sessionState)).setter(setter(Builder::sessionState))
            .constructor(SessionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceArn").getter(getter(InvokeAgentRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-source-arn").build()).build();

    private static final SdkField<StreamingConfigurations> STREAMING_CONFIGURATIONS_FIELD = SdkField
            .<StreamingConfigurations> builder(MarshallingType.SDK_POJO).memberName("streamingConfigurations")
            .getter(getter(InvokeAgentRequest::streamingConfigurations)).setter(setter(Builder::streamingConfigurations))
            .constructor(StreamingConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingConfigurations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_ID_FIELD,
            AGENT_ID_FIELD, BEDROCK_MODEL_CONFIGURATIONS_FIELD, ENABLE_TRACE_FIELD, END_SESSION_FIELD, INPUT_TEXT_FIELD,
            MEMORY_ID_FIELD, PROMPT_CREATION_CONFIGURATIONS_FIELD, SESSION_ID_FIELD, SESSION_STATE_FIELD, SOURCE_ARN_FIELD,
            STREAMING_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentAliasId;

    private final String agentId;

    private final BedrockModelConfigurations bedrockModelConfigurations;

    private final Boolean enableTrace;

    private final Boolean endSession;

    private final String inputText;

    private final String memoryId;

    private final PromptCreationConfigurations promptCreationConfigurations;

    private final String sessionId;

    private final SessionState sessionState;

    private final String sourceArn;

    private final StreamingConfigurations streamingConfigurations;

    private InvokeAgentRequest(BuilderImpl builder) {
        super(builder);
        this.agentAliasId = builder.agentAliasId;
        this.agentId = builder.agentId;
        this.bedrockModelConfigurations = builder.bedrockModelConfigurations;
        this.enableTrace = builder.enableTrace;
        this.endSession = builder.endSession;
        this.inputText = builder.inputText;
        this.memoryId = builder.memoryId;
        this.promptCreationConfigurations = builder.promptCreationConfigurations;
        this.sessionId = builder.sessionId;
        this.sessionState = builder.sessionState;
        this.sourceArn = builder.sourceArn;
        this.streamingConfigurations = builder.streamingConfigurations;
    }

    /**
     * <p>
     * The alias of the agent to use.
     * </p>
     * 
     * @return The alias of the agent to use.
     */
    public final String agentAliasId() {
        return agentAliasId;
    }

    /**
     * <p>
     * The unique identifier of the agent to use.
     * </p>
     * 
     * @return The unique identifier of the agent to use.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * Model performance settings for the request.
     * </p>
     * 
     * @return Model performance settings for the request.
     */
    public final BedrockModelConfigurations bedrockModelConfigurations() {
        return bedrockModelConfigurations;
    }

    /**
     * <p>
     * Specifies whether to turn on the trace or not to track the agent's reasoning process. For more information, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace
     * enablement</a>.
     * </p>
     * 
     * @return Specifies whether to turn on the trace or not to track the agent's reasoning process. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace
     *         enablement</a>.
     */
    public final Boolean enableTrace() {
        return enableTrace;
    }

    /**
     * <p>
     * Specifies whether to end the session with the agent or not.
     * </p>
     * 
     * @return Specifies whether to end the session with the agent or not.
     */
    public final Boolean endSession() {
        return endSession;
    }

    /**
     * <p>
     * The prompt text to send the agent.
     * </p>
     * <note>
     * <p>
     * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     * <code>inputText</code> field will be ignored.
     * </p>
     * </note>
     * 
     * @return The prompt text to send the agent.</p> <note>
     *         <p>
     *         If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     *         <code>inputText</code> field will be ignored.
     *         </p>
     */
    public final String inputText() {
        return inputText;
    }

    /**
     * <p>
     * The unique identifier of the agent memory.
     * </p>
     * 
     * @return The unique identifier of the agent memory.
     */
    public final String memoryId() {
        return memoryId;
    }

    /**
     * <p>
     * Specifies parameters that control how the service populates the agent prompt for an <code>InvokeAgent</code>
     * request. You can control which aspects of previous invocations in the same agent session the service uses to
     * populate the agent prompt. This gives you more granular control over the contextual history that is used to
     * process the current request.
     * </p>
     * 
     * @return Specifies parameters that control how the service populates the agent prompt for an
     *         <code>InvokeAgent</code> request. You can control which aspects of previous invocations in the same agent
     *         session the service uses to populate the agent prompt. This gives you more granular control over the
     *         contextual history that is used to process the current request.
     */
    public final PromptCreationConfigurations promptCreationConfigurations() {
        return promptCreationConfigurations;
    }

    /**
     * <p>
     * The unique identifier of the session. Use the same value across requests to continue the same conversation.
     * </p>
     * 
     * @return The unique identifier of the session. Use the same value across requests to continue the same
     *         conversation.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Contains parameters that specify various attributes of the session. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     * context</a>.
     * </p>
     * <note>
     * <p>
     * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     * <code>inputText</code> field will be ignored.
     * </p>
     * </note>
     * 
     * @return Contains parameters that specify various attributes of the session. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     *         context</a>.</p> <note>
     *         <p>
     *         If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     *         <code>inputText</code> field will be ignored.
     *         </p>
     */
    public final SessionState sessionState() {
        return sessionState;
    }

    /**
     * <p>
     * The ARN of the resource making the request.
     * </p>
     * 
     * @return The ARN of the resource making the request.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * Specifies the configurations for streaming.
     * </p>
     * <note>
     * <p>
     * To use agent streaming, you need permissions to perform the <code>bedrock:InvokeModelWithResponseStream</code>
     * action.
     * </p>
     * </note>
     * 
     * @return Specifies the configurations for streaming. </p> <note>
     *         <p>
     *         To use agent streaming, you need permissions to perform the
     *         <code>bedrock:InvokeModelWithResponseStream</code> action.
     *         </p>
     */
    public final StreamingConfigurations streamingConfigurations() {
        return streamingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(bedrockModelConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(enableTrace());
        hashCode = 31 * hashCode + Objects.hashCode(endSession());
        hashCode = 31 * hashCode + Objects.hashCode(inputText());
        hashCode = 31 * hashCode + Objects.hashCode(memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(promptCreationConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamingConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAgentRequest)) {
            return false;
        }
        InvokeAgentRequest other = (InvokeAgentRequest) obj;
        return Objects.equals(agentAliasId(), other.agentAliasId()) && Objects.equals(agentId(), other.agentId())
                && Objects.equals(bedrockModelConfigurations(), other.bedrockModelConfigurations())
                && Objects.equals(enableTrace(), other.enableTrace()) && Objects.equals(endSession(), other.endSession())
                && Objects.equals(inputText(), other.inputText()) && Objects.equals(memoryId(), other.memoryId())
                && Objects.equals(promptCreationConfigurations(), other.promptCreationConfigurations())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(sessionState(), other.sessionState())
                && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(streamingConfigurations(), other.streamingConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeAgentRequest").add("AgentAliasId", agentAliasId()).add("AgentId", agentId())
                .add("BedrockModelConfigurations", bedrockModelConfigurations()).add("EnableTrace", enableTrace())
                .add("EndSession", endSession()).add("InputText", inputText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MemoryId", memoryId()).add("PromptCreationConfigurations", promptCreationConfigurations())
                .add("SessionId", sessionId()).add("SessionState", sessionState()).add("SourceArn", sourceArn())
                .add("StreamingConfigurations", streamingConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentAliasId":
            return Optional.ofNullable(clazz.cast(agentAliasId()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "bedrockModelConfigurations":
            return Optional.ofNullable(clazz.cast(bedrockModelConfigurations()));
        case "enableTrace":
            return Optional.ofNullable(clazz.cast(enableTrace()));
        case "endSession":
            return Optional.ofNullable(clazz.cast(endSession()));
        case "inputText":
            return Optional.ofNullable(clazz.cast(inputText()));
        case "memoryId":
            return Optional.ofNullable(clazz.cast(memoryId()));
        case "promptCreationConfigurations":
            return Optional.ofNullable(clazz.cast(promptCreationConfigurations()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        case "sourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "streamingConfigurations":
            return Optional.ofNullable(clazz.cast(streamingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentAliasId", AGENT_ALIAS_ID_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("bedrockModelConfigurations", BEDROCK_MODEL_CONFIGURATIONS_FIELD);
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        map.put("endSession", END_SESSION_FIELD);
        map.put("inputText", INPUT_TEXT_FIELD);
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("promptCreationConfigurations", PROMPT_CREATION_CONFIGURATIONS_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionState", SESSION_STATE_FIELD);
        map.put("x-amz-source-arn", SOURCE_ARN_FIELD);
        map.put("streamingConfigurations", STREAMING_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeAgentRequest, T> g) {
        return obj -> g.apply((InvokeAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeAgentRequest> {
        /**
         * <p>
         * The alias of the agent to use.
         * </p>
         * 
         * @param agentAliasId
         *        The alias of the agent to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasId(String agentAliasId);

        /**
         * <p>
         * The unique identifier of the agent to use.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * Model performance settings for the request.
         * </p>
         * 
         * @param bedrockModelConfigurations
         *        Model performance settings for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockModelConfigurations(BedrockModelConfigurations bedrockModelConfigurations);

        /**
         * <p>
         * Model performance settings for the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link BedrockModelConfigurations.Builder}
         * avoiding the need to create one manually via {@link BedrockModelConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockModelConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #bedrockModelConfigurations(BedrockModelConfigurations)}.
         * 
         * @param bedrockModelConfigurations
         *        a consumer that will call methods on {@link BedrockModelConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockModelConfigurations(BedrockModelConfigurations)
         */
        default Builder bedrockModelConfigurations(Consumer<BedrockModelConfigurations.Builder> bedrockModelConfigurations) {
            return bedrockModelConfigurations(BedrockModelConfigurations.builder().applyMutation(bedrockModelConfigurations)
                    .build());
        }

        /**
         * <p>
         * Specifies whether to turn on the trace or not to track the agent's reasoning process. For more information,
         * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace
         * enablement</a>.
         * </p>
         * 
         * @param enableTrace
         *        Specifies whether to turn on the trace or not to track the agent's reasoning process. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace
         *        enablement</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTrace(Boolean enableTrace);

        /**
         * <p>
         * Specifies whether to end the session with the agent or not.
         * </p>
         * 
         * @param endSession
         *        Specifies whether to end the session with the agent or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endSession(Boolean endSession);

        /**
         * <p>
         * The prompt text to send the agent.
         * </p>
         * <note>
         * <p>
         * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         * <code>inputText</code> field will be ignored.
         * </p>
         * </note>
         * 
         * @param inputText
         *        The prompt text to send the agent.</p> <note>
         *        <p>
         *        If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         *        <code>inputText</code> field will be ignored.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputText(String inputText);

        /**
         * <p>
         * The unique identifier of the agent memory.
         * </p>
         * 
         * @param memoryId
         *        The unique identifier of the agent memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryId(String memoryId);

        /**
         * <p>
         * Specifies parameters that control how the service populates the agent prompt for an <code>InvokeAgent</code>
         * request. You can control which aspects of previous invocations in the same agent session the service uses to
         * populate the agent prompt. This gives you more granular control over the contextual history that is used to
         * process the current request.
         * </p>
         * 
         * @param promptCreationConfigurations
         *        Specifies parameters that control how the service populates the agent prompt for an
         *        <code>InvokeAgent</code> request. You can control which aspects of previous invocations in the same
         *        agent session the service uses to populate the agent prompt. This gives you more granular control over
         *        the contextual history that is used to process the current request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptCreationConfigurations(PromptCreationConfigurations promptCreationConfigurations);

        /**
         * <p>
         * Specifies parameters that control how the service populates the agent prompt for an <code>InvokeAgent</code>
         * request. You can control which aspects of previous invocations in the same agent session the service uses to
         * populate the agent prompt. This gives you more granular control over the contextual history that is used to
         * process the current request.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptCreationConfigurations.Builder}
         * avoiding the need to create one manually via {@link PromptCreationConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptCreationConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #promptCreationConfigurations(PromptCreationConfigurations)}.
         * 
         * @param promptCreationConfigurations
         *        a consumer that will call methods on {@link PromptCreationConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptCreationConfigurations(PromptCreationConfigurations)
         */
        default Builder promptCreationConfigurations(Consumer<PromptCreationConfigurations.Builder> promptCreationConfigurations) {
            return promptCreationConfigurations(PromptCreationConfigurations.builder()
                    .applyMutation(promptCreationConfigurations).build());
        }

        /**
         * <p>
         * The unique identifier of the session. Use the same value across requests to continue the same conversation.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the session. Use the same value across requests to continue the same
         *        conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Contains parameters that specify various attributes of the session. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * <note>
         * <p>
         * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         * <code>inputText</code> field will be ignored.
         * </p>
         * </note>
         * 
         * @param sessionState
         *        Contains parameters that specify various attributes of the session. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         *        context</a>.</p> <note>
         *        <p>
         *        If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         *        <code>inputText</code> field will be ignored.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(SessionState sessionState);

        /**
         * <p>
         * Contains parameters that specify various attributes of the session. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * <note>
         * <p>
         * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         * <code>inputText</code> field will be ignored.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link SessionState.Builder} avoiding
         * the need to create one manually via {@link SessionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionState.Builder#build()} is called immediately and its
         * result is passed to {@link #sessionState(SessionState)}.
         * 
         * @param sessionState
         *        a consumer that will call methods on {@link SessionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionState(SessionState)
         */
        default Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return sessionState(SessionState.builder().applyMutation(sessionState).build());
        }

        /**
         * <p>
         * The ARN of the resource making the request.
         * </p>
         * 
         * @param sourceArn
         *        The ARN of the resource making the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * Specifies the configurations for streaming.
         * </p>
         * <note>
         * <p>
         * To use agent streaming, you need permissions to perform the
         * <code>bedrock:InvokeModelWithResponseStream</code> action.
         * </p>
         * </note>
         * 
         * @param streamingConfigurations
         *        Specifies the configurations for streaming. </p> <note>
         *        <p>
         *        To use agent streaming, you need permissions to perform the
         *        <code>bedrock:InvokeModelWithResponseStream</code> action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingConfigurations(StreamingConfigurations streamingConfigurations);

        /**
         * <p>
         * Specifies the configurations for streaming.
         * </p>
         * <note>
         * <p>
         * To use agent streaming, you need permissions to perform the
         * <code>bedrock:InvokeModelWithResponseStream</code> action.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link StreamingConfigurations.Builder}
         * avoiding the need to create one manually via {@link StreamingConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamingConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #streamingConfigurations(StreamingConfigurations)}.
         * 
         * @param streamingConfigurations
         *        a consumer that will call methods on {@link StreamingConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingConfigurations(StreamingConfigurations)
         */
        default Builder streamingConfigurations(Consumer<StreamingConfigurations.Builder> streamingConfigurations) {
            return streamingConfigurations(StreamingConfigurations.builder().applyMutation(streamingConfigurations).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String agentAliasId;

        private String agentId;

        private BedrockModelConfigurations bedrockModelConfigurations;

        private Boolean enableTrace;

        private Boolean endSession;

        private String inputText;

        private String memoryId;

        private PromptCreationConfigurations promptCreationConfigurations;

        private String sessionId;

        private SessionState sessionState;

        private String sourceArn;

        private StreamingConfigurations streamingConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAgentRequest model) {
            super(model);
            agentAliasId(model.agentAliasId);
            agentId(model.agentId);
            bedrockModelConfigurations(model.bedrockModelConfigurations);
            enableTrace(model.enableTrace);
            endSession(model.endSession);
            inputText(model.inputText);
            memoryId(model.memoryId);
            promptCreationConfigurations(model.promptCreationConfigurations);
            sessionId(model.sessionId);
            sessionState(model.sessionState);
            sourceArn(model.sourceArn);
            streamingConfigurations(model.streamingConfigurations);
        }

        public final String getAgentAliasId() {
            return agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final BedrockModelConfigurations.Builder getBedrockModelConfigurations() {
            return bedrockModelConfigurations != null ? bedrockModelConfigurations.toBuilder() : null;
        }

        public final void setBedrockModelConfigurations(BedrockModelConfigurations.BuilderImpl bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations != null ? bedrockModelConfigurations.build() : null;
        }

        @Override
        public final Builder bedrockModelConfigurations(BedrockModelConfigurations bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations;
            return this;
        }

        public final Boolean getEnableTrace() {
            return enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        public final Boolean getEndSession() {
            return endSession;
        }

        public final void setEndSession(Boolean endSession) {
            this.endSession = endSession;
        }

        @Override
        public final Builder endSession(Boolean endSession) {
            this.endSession = endSession;
            return this;
        }

        public final String getInputText() {
            return inputText;
        }

        public final void setInputText(String inputText) {
            this.inputText = inputText;
        }

        @Override
        public final Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        public final String getMemoryId() {
            return memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final PromptCreationConfigurations.Builder getPromptCreationConfigurations() {
            return promptCreationConfigurations != null ? promptCreationConfigurations.toBuilder() : null;
        }

        public final void setPromptCreationConfigurations(PromptCreationConfigurations.BuilderImpl promptCreationConfigurations) {
            this.promptCreationConfigurations = promptCreationConfigurations != null ? promptCreationConfigurations.build()
                    : null;
        }

        @Override
        public final Builder promptCreationConfigurations(PromptCreationConfigurations promptCreationConfigurations) {
            this.promptCreationConfigurations = promptCreationConfigurations;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final SessionState.Builder getSessionState() {
            return sessionState != null ? sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final StreamingConfigurations.Builder getStreamingConfigurations() {
            return streamingConfigurations != null ? streamingConfigurations.toBuilder() : null;
        }

        public final void setStreamingConfigurations(StreamingConfigurations.BuilderImpl streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations != null ? streamingConfigurations.build() : null;
        }

        @Override
        public final Builder streamingConfigurations(StreamingConfigurations streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeAgentRequest build() {
            return new InvokeAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
