/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class GuardrailPiiEntityFilterListCopier {
    static List<GuardrailPiiEntityFilter> copy(Collection<? extends GuardrailPiiEntityFilter> guardrailPiiEntityFilterListParam) {
        List<GuardrailPiiEntityFilter> list;
        if (guardrailPiiEntityFilterListParam == null || guardrailPiiEntityFilterListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GuardrailPiiEntityFilter> modifiableList = new ArrayList<>(guardrailPiiEntityFilterListParam.size());
            guardrailPiiEntityFilterListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GuardrailPiiEntityFilter> copyFromBuilder(
            Collection<? extends GuardrailPiiEntityFilter.Builder> guardrailPiiEntityFilterListParam) {
        List<GuardrailPiiEntityFilter> list;
        if (guardrailPiiEntityFilterListParam == null || guardrailPiiEntityFilterListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GuardrailPiiEntityFilter> modifiableList = new ArrayList<>(guardrailPiiEntityFilterListParam.size());
            guardrailPiiEntityFilterListParam.forEach(entry -> {
                GuardrailPiiEntityFilter member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GuardrailPiiEntityFilter.Builder> copyToBuilder(
            Collection<? extends GuardrailPiiEntityFilter> guardrailPiiEntityFilterListParam) {
        List<GuardrailPiiEntityFilter.Builder> list;
        if (guardrailPiiEntityFilterListParam == null || guardrailPiiEntityFilterListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GuardrailPiiEntityFilter.Builder> modifiableList = new ArrayList<>(guardrailPiiEntityFilterListParam.size());
            guardrailPiiEntityFilterListParam.forEach(entry -> {
                GuardrailPiiEntityFilter.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
