/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInvocationStepRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<GetInvocationStepRequest.Builder, GetInvocationStepRequest> {
    private static final SdkField<String> INVOCATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationIdentifier").getter(getter(GetInvocationStepRequest::invocationIdentifier))
            .setter(setter(Builder::invocationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationIdentifier").build())
            .build();

    private static final SdkField<String> INVOCATION_STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationStepId").getter(getter(GetInvocationStepRequest::invocationStepId))
            .setter(setter(Builder::invocationStepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("invocationStepId").build()).build();

    private static final SdkField<String> SESSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionIdentifier").getter(getter(GetInvocationStepRequest::sessionIdentifier))
            .setter(setter(Builder::sessionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_IDENTIFIER_FIELD,
            INVOCATION_STEP_ID_FIELD, SESSION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String invocationIdentifier;

    private final String invocationStepId;

    private final String sessionIdentifier;

    private GetInvocationStepRequest(BuilderImpl builder) {
        super(builder);
        this.invocationIdentifier = builder.invocationIdentifier;
        this.invocationStepId = builder.invocationStepId;
        this.sessionIdentifier = builder.sessionIdentifier;
    }

    /**
     * <p>
     * The unique identifier for the invocation in UUID format.
     * </p>
     * 
     * @return The unique identifier for the invocation in UUID format.
     */
    public final String invocationIdentifier() {
        return invocationIdentifier;
    }

    /**
     * <p>
     * The unique identifier (in UUID format) for the specific invocation step to retrieve.
     * </p>
     * 
     * @return The unique identifier (in UUID format) for the specific invocation step to retrieve.
     */
    public final String invocationStepId() {
        return invocationStepId;
    }

    /**
     * <p>
     * The unique identifier for the invocation step's associated session. You can specify either the session's
     * <code>sessionId</code> or its Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The unique identifier for the invocation step's associated session. You can specify either the session's
     *         <code>sessionId</code> or its Amazon Resource Name (ARN).
     */
    public final String sessionIdentifier() {
        return sessionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invocationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(invocationStepId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvocationStepRequest)) {
            return false;
        }
        GetInvocationStepRequest other = (GetInvocationStepRequest) obj;
        return Objects.equals(invocationIdentifier(), other.invocationIdentifier())
                && Objects.equals(invocationStepId(), other.invocationStepId())
                && Objects.equals(sessionIdentifier(), other.sessionIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInvocationStepRequest").add("InvocationIdentifier", invocationIdentifier())
                .add("InvocationStepId", invocationStepId()).add("SessionIdentifier", sessionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationIdentifier":
            return Optional.ofNullable(clazz.cast(invocationIdentifier()));
        case "invocationStepId":
            return Optional.ofNullable(clazz.cast(invocationStepId()));
        case "sessionIdentifier":
            return Optional.ofNullable(clazz.cast(sessionIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationIdentifier", INVOCATION_IDENTIFIER_FIELD);
        map.put("invocationStepId", INVOCATION_STEP_ID_FIELD);
        map.put("sessionIdentifier", SESSION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInvocationStepRequest, T> g) {
        return obj -> g.apply((GetInvocationStepRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInvocationStepRequest> {
        /**
         * <p>
         * The unique identifier for the invocation in UUID format.
         * </p>
         * 
         * @param invocationIdentifier
         *        The unique identifier for the invocation in UUID format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationIdentifier(String invocationIdentifier);

        /**
         * <p>
         * The unique identifier (in UUID format) for the specific invocation step to retrieve.
         * </p>
         * 
         * @param invocationStepId
         *        The unique identifier (in UUID format) for the specific invocation step to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationStepId(String invocationStepId);

        /**
         * <p>
         * The unique identifier for the invocation step's associated session. You can specify either the session's
         * <code>sessionId</code> or its Amazon Resource Name (ARN).
         * </p>
         * 
         * @param sessionIdentifier
         *        The unique identifier for the invocation step's associated session. You can specify either the
         *        session's <code>sessionId</code> or its Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionIdentifier(String sessionIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String invocationIdentifier;

        private String invocationStepId;

        private String sessionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvocationStepRequest model) {
            super(model);
            invocationIdentifier(model.invocationIdentifier);
            invocationStepId(model.invocationStepId);
            sessionIdentifier(model.sessionIdentifier);
        }

        public final String getInvocationIdentifier() {
            return invocationIdentifier;
        }

        public final void setInvocationIdentifier(String invocationIdentifier) {
            this.invocationIdentifier = invocationIdentifier;
        }

        @Override
        public final Builder invocationIdentifier(String invocationIdentifier) {
            this.invocationIdentifier = invocationIdentifier;
            return this;
        }

        public final String getInvocationStepId() {
            return invocationStepId;
        }

        public final void setInvocationStepId(String invocationStepId) {
            this.invocationStepId = invocationStepId;
        }

        @Override
        public final Builder invocationStepId(String invocationStepId) {
            this.invocationStepId = invocationStepId;
            return this;
        }

        public final String getSessionIdentifier() {
            return sessionIdentifier;
        }

        public final void setSessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
        }

        @Override
        public final Builder sessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInvocationStepRequest build() {
            return new GetInvocationStepRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
