/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExecutionFlowSnapshotResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<GetExecutionFlowSnapshotResponse.Builder, GetExecutionFlowSnapshotResponse> {
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyArn").getter(getter(GetExecutionFlowSnapshotResponse::customerEncryptionKeyArn))
            .setter(setter(Builder::customerEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build())
            .build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(GetExecutionFlowSnapshotResponse::definition))
            .setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(GetExecutionFlowSnapshotResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowAliasIdentifier").getter(getter(GetExecutionFlowSnapshotResponse::flowAliasIdentifier))
            .setter(setter(Builder::flowAliasIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowAliasIdentifier").build())
            .build();

    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowIdentifier").getter(getter(GetExecutionFlowSnapshotResponse::flowIdentifier))
            .setter(setter(Builder::flowIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowIdentifier").build()).build();

    private static final SdkField<String> FLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowVersion").getter(getter(GetExecutionFlowSnapshotResponse::flowVersion))
            .setter(setter(Builder::flowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DEFINITION_FIELD, EXECUTION_ROLE_ARN_FIELD, FLOW_ALIAS_IDENTIFIER_FIELD,
            FLOW_IDENTIFIER_FIELD, FLOW_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String customerEncryptionKeyArn;

    private final String definition;

    private final String executionRoleArn;

    private final String flowAliasIdentifier;

    private final String flowIdentifier;

    private final String flowVersion;

    private GetExecutionFlowSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.definition = builder.definition;
        this.executionRoleArn = builder.executionRoleArn;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
        this.flowVersion = builder.flowVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the customer managed KMS key that's used to encrypt the flow snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the customer managed KMS key that's used to encrypt the flow snapshot.
     */
    public final String customerEncryptionKeyArn() {
        return customerEncryptionKeyArn;
    }

    /**
     * <p>
     * The flow definition used for the flow execution, including the nodes, connections, and configuration at the time
     * when the execution started.
     * </p>
     * <p>
     * The definition returns as a string that follows the structure of a <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowDefinition.html">FlowDefinition</a>
     * object.
     * </p>
     * 
     * @return The flow definition used for the flow execution, including the nodes, connections, and configuration at
     *         the time when the execution started.</p>
     *         <p>
     *         The definition returns as a string that follows the structure of a <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowDefinition.html"
     *         >FlowDefinition</a> object.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role that's used by the flow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role that's used by the flow execution.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The unique identifier of the flow alias used for the flow execution.
     * </p>
     * 
     * @return The unique identifier of the flow alias used for the flow execution.
     */
    public final String flowAliasIdentifier() {
        return flowAliasIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String flowIdentifier() {
        return flowIdentifier;
    }

    /**
     * <p>
     * The version of the flow used for the flow execution.
     * </p>
     * 
     * @return The version of the flow used for the flow execution.
     */
    public final String flowVersion() {
        return flowVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExecutionFlowSnapshotResponse)) {
            return false;
        }
        GetExecutionFlowSnapshotResponse other = (GetExecutionFlowSnapshotResponse) obj;
        return Objects.equals(customerEncryptionKeyArn(), other.customerEncryptionKeyArn())
                && Objects.equals(definition(), other.definition())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(flowAliasIdentifier(), other.flowAliasIdentifier())
                && Objects.equals(flowIdentifier(), other.flowIdentifier()) && Objects.equals(flowVersion(), other.flowVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExecutionFlowSnapshotResponse").add("CustomerEncryptionKeyArn", customerEncryptionKeyArn())
                .add("Definition", definition()).add("ExecutionRoleArn", executionRoleArn())
                .add("FlowAliasIdentifier", flowAliasIdentifier()).add("FlowIdentifier", flowIdentifier())
                .add("FlowVersion", flowVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyArn()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "flowAliasIdentifier":
            return Optional.ofNullable(clazz.cast(flowAliasIdentifier()));
        case "flowIdentifier":
            return Optional.ofNullable(clazz.cast(flowIdentifier()));
        case "flowVersion":
            return Optional.ofNullable(clazz.cast(flowVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("flowVersion", FLOW_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExecutionFlowSnapshotResponse, T> g) {
        return obj -> g.apply((GetExecutionFlowSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetExecutionFlowSnapshotResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the customer managed KMS key that's used to encrypt the flow snapshot.
         * </p>
         * 
         * @param customerEncryptionKeyArn
         *        The Amazon Resource Name (ARN) of the customer managed KMS key that's used to encrypt the flow
         *        snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyArn(String customerEncryptionKeyArn);

        /**
         * <p>
         * The flow definition used for the flow execution, including the nodes, connections, and configuration at the
         * time when the execution started.
         * </p>
         * <p>
         * The definition returns as a string that follows the structure of a <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowDefinition.html"
         * >FlowDefinition</a> object.
         * </p>
         * 
         * @param definition
         *        The flow definition used for the flow execution, including the nodes, connections, and configuration
         *        at the time when the execution started.</p>
         *        <p>
         *        The definition returns as a string that follows the structure of a <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowDefinition.html"
         *        >FlowDefinition</a> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role that's used by the flow execution.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role that's used by the flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The unique identifier of the flow alias used for the flow execution.
         * </p>
         * 
         * @param flowAliasIdentifier
         *        The unique identifier of the flow alias used for the flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowAliasIdentifier(String flowAliasIdentifier);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param flowIdentifier
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowIdentifier(String flowIdentifier);

        /**
         * <p>
         * The version of the flow used for the flow execution.
         * </p>
         * 
         * @param flowVersion
         *        The version of the flow used for the flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowVersion(String flowVersion);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private String customerEncryptionKeyArn;

        private String definition;

        private String executionRoleArn;

        private String flowAliasIdentifier;

        private String flowIdentifier;

        private String flowVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExecutionFlowSnapshotResponse model) {
            super(model);
            customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            definition(model.definition);
            executionRoleArn(model.executionRoleArn);
            flowAliasIdentifier(model.flowAliasIdentifier);
            flowIdentifier(model.flowIdentifier);
            flowVersion(model.flowVersion);
        }

        public final String getCustomerEncryptionKeyArn() {
            return customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getFlowVersion() {
            return flowVersion;
        }

        public final void setFlowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
        }

        @Override
        public final Builder flowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
            return this;
        }

        @Override
        public GetExecutionFlowSnapshotResponse build() {
            return new GetExecutionFlowSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
