/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateQueryRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<GenerateQueryRequest.Builder, GenerateQueryRequest> {
    private static final SdkField<QueryGenerationInput> QUERY_GENERATION_INPUT_FIELD = SdkField
            .<QueryGenerationInput> builder(MarshallingType.SDK_POJO).memberName("queryGenerationInput")
            .getter(getter(GenerateQueryRequest::queryGenerationInput)).setter(setter(Builder::queryGenerationInput))
            .constructor(QueryGenerationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryGenerationInput").build())
            .build();

    private static final SdkField<TransformationConfiguration> TRANSFORMATION_CONFIGURATION_FIELD = SdkField
            .<TransformationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("transformationConfiguration")
            .getter(getter(GenerateQueryRequest::transformationConfiguration))
            .setter(setter(Builder::transformationConfiguration))
            .constructor(TransformationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_GENERATION_INPUT_FIELD,
            TRANSFORMATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final QueryGenerationInput queryGenerationInput;

    private final TransformationConfiguration transformationConfiguration;

    private GenerateQueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryGenerationInput = builder.queryGenerationInput;
        this.transformationConfiguration = builder.transformationConfiguration;
    }

    /**
     * <p>
     * Specifies information about a natural language query to transform into SQL.
     * </p>
     * 
     * @return Specifies information about a natural language query to transform into SQL.
     */
    public final QueryGenerationInput queryGenerationInput() {
        return queryGenerationInput;
    }

    /**
     * <p>
     * Specifies configurations for transforming the natural language query into SQL.
     * </p>
     * 
     * @return Specifies configurations for transforming the natural language query into SQL.
     */
    public final TransformationConfiguration transformationConfiguration() {
        return transformationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryGenerationInput());
        hashCode = 31 * hashCode + Objects.hashCode(transformationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateQueryRequest)) {
            return false;
        }
        GenerateQueryRequest other = (GenerateQueryRequest) obj;
        return Objects.equals(queryGenerationInput(), other.queryGenerationInput())
                && Objects.equals(transformationConfiguration(), other.transformationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateQueryRequest")
                .add("QueryGenerationInput", queryGenerationInput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TransformationConfiguration", transformationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryGenerationInput":
            return Optional.ofNullable(clazz.cast(queryGenerationInput()));
        case "transformationConfiguration":
            return Optional.ofNullable(clazz.cast(transformationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryGenerationInput", QUERY_GENERATION_INPUT_FIELD);
        map.put("transformationConfiguration", TRANSFORMATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateQueryRequest, T> g) {
        return obj -> g.apply((GenerateQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, GenerateQueryRequest> {
        /**
         * <p>
         * Specifies information about a natural language query to transform into SQL.
         * </p>
         * 
         * @param queryGenerationInput
         *        Specifies information about a natural language query to transform into SQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryGenerationInput(QueryGenerationInput queryGenerationInput);

        /**
         * <p>
         * Specifies information about a natural language query to transform into SQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryGenerationInput.Builder} avoiding
         * the need to create one manually via {@link QueryGenerationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryGenerationInput.Builder#build()} is called immediately and
         * its result is passed to {@link #queryGenerationInput(QueryGenerationInput)}.
         * 
         * @param queryGenerationInput
         *        a consumer that will call methods on {@link QueryGenerationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryGenerationInput(QueryGenerationInput)
         */
        default Builder queryGenerationInput(Consumer<QueryGenerationInput.Builder> queryGenerationInput) {
            return queryGenerationInput(QueryGenerationInput.builder().applyMutation(queryGenerationInput).build());
        }

        /**
         * <p>
         * Specifies configurations for transforming the natural language query into SQL.
         * </p>
         * 
         * @param transformationConfiguration
         *        Specifies configurations for transforming the natural language query into SQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformationConfiguration(TransformationConfiguration transformationConfiguration);

        /**
         * <p>
         * Specifies configurations for transforming the natural language query into SQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformationConfiguration.Builder}
         * avoiding the need to create one manually via {@link TransformationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #transformationConfiguration(TransformationConfiguration)}.
         * 
         * @param transformationConfiguration
         *        a consumer that will call methods on {@link TransformationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformationConfiguration(TransformationConfiguration)
         */
        default Builder transformationConfiguration(Consumer<TransformationConfiguration.Builder> transformationConfiguration) {
            return transformationConfiguration(TransformationConfiguration.builder().applyMutation(transformationConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private QueryGenerationInput queryGenerationInput;

        private TransformationConfiguration transformationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateQueryRequest model) {
            super(model);
            queryGenerationInput(model.queryGenerationInput);
            transformationConfiguration(model.transformationConfiguration);
        }

        public final QueryGenerationInput.Builder getQueryGenerationInput() {
            return queryGenerationInput != null ? queryGenerationInput.toBuilder() : null;
        }

        public final void setQueryGenerationInput(QueryGenerationInput.BuilderImpl queryGenerationInput) {
            this.queryGenerationInput = queryGenerationInput != null ? queryGenerationInput.build() : null;
        }

        @Override
        public final Builder queryGenerationInput(QueryGenerationInput queryGenerationInput) {
            this.queryGenerationInput = queryGenerationInput;
            return this;
        }

        public final TransformationConfiguration.Builder getTransformationConfiguration() {
            return transformationConfiguration != null ? transformationConfiguration.toBuilder() : null;
        }

        public final void setTransformationConfiguration(TransformationConfiguration.BuilderImpl transformationConfiguration) {
            this.transformationConfiguration = transformationConfiguration != null ? transformationConfiguration.build() : null;
        }

        @Override
        public final Builder transformationConfiguration(TransformationConfiguration transformationConfiguration) {
            this.transformationConfiguration = transformationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateQueryRequest build() {
            return new GenerateQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
