/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvocationRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<CreateInvocationRequest.Builder, CreateInvocationRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateInvocationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationId").getter(getter(CreateInvocationRequest::invocationId))
            .setter(setter(Builder::invocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()).build();

    private static final SdkField<String> SESSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionIdentifier").getter(getter(CreateInvocationRequest::sessionIdentifier))
            .setter(setter(Builder::sessionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            INVOCATION_ID_FIELD, SESSION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String invocationId;

    private final String sessionIdentifier;

    private CreateInvocationRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.invocationId = builder.invocationId;
        this.sessionIdentifier = builder.sessionIdentifier;
    }

    /**
     * <p>
     * A description for the interactions in the invocation. For example, "User asking about weather in Seattle".
     * </p>
     * 
     * @return A description for the interactions in the invocation. For example,
     *         "User asking about weather in Seattle".
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique identifier for the invocation in UUID format.
     * </p>
     * 
     * @return A unique identifier for the invocation in UUID format.
     */
    public final String invocationId() {
        return invocationId;
    }

    /**
     * <p>
     * The unique identifier for the associated session for the invocation. You can specify either the session's
     * <code>sessionId</code> or its Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The unique identifier for the associated session for the invocation. You can specify either the session's
     *         <code>sessionId</code> or its Amazon Resource Name (ARN).
     */
    public final String sessionIdentifier() {
        return sessionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvocationRequest)) {
            return false;
        }
        CreateInvocationRequest other = (CreateInvocationRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(invocationId(), other.invocationId())
                && Objects.equals(sessionIdentifier(), other.sessionIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInvocationRequest").add("Description", description()).add("InvocationId", invocationId())
                .add("SessionIdentifier", sessionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "invocationId":
            return Optional.ofNullable(clazz.cast(invocationId()));
        case "sessionIdentifier":
            return Optional.ofNullable(clazz.cast(sessionIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("invocationId", INVOCATION_ID_FIELD);
        map.put("sessionIdentifier", SESSION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInvocationRequest, T> g) {
        return obj -> g.apply((CreateInvocationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInvocationRequest> {
        /**
         * <p>
         * A description for the interactions in the invocation. For example, "User asking about weather in Seattle".
         * </p>
         * 
         * @param description
         *        A description for the interactions in the invocation. For example,
         *        "User asking about weather in Seattle".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique identifier for the invocation in UUID format.
         * </p>
         * 
         * @param invocationId
         *        A unique identifier for the invocation in UUID format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);

        /**
         * <p>
         * The unique identifier for the associated session for the invocation. You can specify either the session's
         * <code>sessionId</code> or its Amazon Resource Name (ARN).
         * </p>
         * 
         * @param sessionIdentifier
         *        The unique identifier for the associated session for the invocation. You can specify either the
         *        session's <code>sessionId</code> or its Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionIdentifier(String sessionIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String description;

        private String invocationId;

        private String sessionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvocationRequest model) {
            super(model);
            description(model.description);
            invocationId(model.invocationId);
            sessionIdentifier(model.sessionIdentifier);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInvocationId() {
            return invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final String getSessionIdentifier() {
            return sessionIdentifier;
        }

        public final void setSessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
        }

        @Override
        public final Builder sessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInvocationRequest build() {
            return new CreateInvocationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
