/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowInputsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.ModelPerformanceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeFlowRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeFlowRequest> {
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(InvokeFlowRequest.getter(InvokeFlowRequest::flowIdentifier)).setter(InvokeFlowRequest.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()}).build();
    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowAliasIdentifier").getter(InvokeFlowRequest.getter(InvokeFlowRequest::flowAliasIdentifier)).setter(InvokeFlowRequest.setter(Builder::flowAliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowAliasIdentifier").build()}).build();
    private static final SdkField<List<FlowInput>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputs").getter(InvokeFlowRequest.getter(InvokeFlowRequest::inputs)).setter(InvokeFlowRequest.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableTrace").getter(InvokeFlowRequest.getter(InvokeFlowRequest::enableTrace)).setter(InvokeFlowRequest.setter(Builder::enableTrace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()}).build();
    private static final SdkField<ModelPerformanceConfiguration> MODEL_PERFORMANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelPerformanceConfiguration").getter(InvokeFlowRequest.getter(InvokeFlowRequest::modelPerformanceConfiguration)).setter(InvokeFlowRequest.setter(Builder::modelPerformanceConfiguration)).constructor(ModelPerformanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelPerformanceConfiguration").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(InvokeFlowRequest.getter(InvokeFlowRequest::executionId)).setter(InvokeFlowRequest.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_IDENTIFIER_FIELD, FLOW_ALIAS_IDENTIFIER_FIELD, INPUTS_FIELD, ENABLE_TRACE_FIELD, MODEL_PERFORMANCE_CONFIGURATION_FIELD, EXECUTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeFlowRequest.memberNameToFieldInitializer();
    private final String flowIdentifier;
    private final String flowAliasIdentifier;
    private final List<FlowInput> inputs;
    private final Boolean enableTrace;
    private final ModelPerformanceConfiguration modelPerformanceConfiguration;
    private final String executionId;

    private InvokeFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowIdentifier = builder.flowIdentifier;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.inputs = builder.inputs;
        this.enableTrace = builder.enableTrace;
        this.modelPerformanceConfiguration = builder.modelPerformanceConfiguration;
        this.executionId = builder.executionId;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final String flowAliasIdentifier() {
        return this.flowAliasIdentifier;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<FlowInput> inputs() {
        return this.inputs;
    }

    public final Boolean enableTrace() {
        return this.enableTrace;
    }

    public final ModelPerformanceConfiguration modelPerformanceConfiguration() {
        return this.modelPerformanceConfiguration;
    }

    public final String executionId() {
        return this.executionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPerformanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeFlowRequest)) {
            return false;
        }
        InvokeFlowRequest other = (InvokeFlowRequest)((Object)obj);
        return Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.flowAliasIdentifier(), other.flowAliasIdentifier()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.enableTrace(), other.enableTrace()) && Objects.equals(this.modelPerformanceConfiguration(), other.modelPerformanceConfiguration()) && Objects.equals(this.executionId(), other.executionId());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeFlowRequest").add("FlowIdentifier", (Object)this.flowIdentifier()).add("FlowAliasIdentifier", (Object)this.flowAliasIdentifier()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("EnableTrace", (Object)this.enableTrace()).add("ModelPerformanceConfiguration", (Object)this.modelPerformanceConfiguration()).add("ExecutionId", (Object)this.executionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "flowAliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowAliasIdentifier()));
            }
            case "inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "enableTrace": {
                return Optional.ofNullable(clazz.cast(this.enableTrace()));
            }
            case "modelPerformanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.modelPerformanceConfiguration()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        map.put("modelPerformanceConfiguration", MODEL_PERFORMANCE_CONFIGURATION_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeFlowRequest, T> g) {
        return obj -> g.apply((InvokeFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String flowIdentifier;
        private String flowAliasIdentifier;
        private List<FlowInput> inputs = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableTrace;
        private ModelPerformanceConfiguration modelPerformanceConfiguration;
        private String executionId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeFlowRequest model) {
            super(model);
            this.flowIdentifier(model.flowIdentifier);
            this.flowAliasIdentifier(model.flowAliasIdentifier);
            this.inputs(model.inputs);
            this.enableTrace(model.enableTrace);
            this.modelPerformanceConfiguration(model.modelPerformanceConfiguration);
            this.executionId(model.executionId);
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return this.flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final List<FlowInput.Builder> getInputs() {
            List<FlowInput.Builder> result = FlowInputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<FlowInput.BuilderImpl> inputs) {
            this.inputs = FlowInputsCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<FlowInput> inputs) {
            this.inputs = FlowInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(FlowInput ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<FlowInput.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (FlowInput)((FlowInput.Builder)FlowInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableTrace() {
            return this.enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        public final ModelPerformanceConfiguration.Builder getModelPerformanceConfiguration() {
            return this.modelPerformanceConfiguration != null ? this.modelPerformanceConfiguration.toBuilder() : null;
        }

        public final void setModelPerformanceConfiguration(ModelPerformanceConfiguration.BuilderImpl modelPerformanceConfiguration) {
            this.modelPerformanceConfiguration = modelPerformanceConfiguration != null ? modelPerformanceConfiguration.build() : null;
        }

        @Override
        public final Builder modelPerformanceConfiguration(ModelPerformanceConfiguration modelPerformanceConfiguration) {
            this.modelPerformanceConfiguration = modelPerformanceConfiguration;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeFlowRequest build() {
            return new InvokeFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeFlowRequest> {
        public Builder flowIdentifier(String var1);

        public Builder flowAliasIdentifier(String var1);

        public Builder inputs(Collection<FlowInput> var1);

        public Builder inputs(FlowInput ... var1);

        public Builder inputs(Consumer<FlowInput.Builder> ... var1);

        public Builder enableTrace(Boolean var1);

        public Builder modelPerformanceConfiguration(ModelPerformanceConfiguration var1);

        default public Builder modelPerformanceConfiguration(Consumer<ModelPerformanceConfiguration.Builder> modelPerformanceConfiguration) {
            return this.modelPerformanceConfiguration((ModelPerformanceConfiguration)((ModelPerformanceConfiguration.Builder)ModelPerformanceConfiguration.builder().applyMutation(modelPerformanceConfiguration)).build());
        }

        public Builder executionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

