/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.ActionGroupInvocationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.AgentCollaboratorInvocationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.CodeInterpreterInvocationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationType;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseLookupInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvocationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvocationInput> {
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(InvocationInput.getter(InvocationInput::traceId)).setter(InvocationInput.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()}).build();
    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationType").getter(InvocationInput.getter(InvocationInput::invocationTypeAsString)).setter(InvocationInput.setter(Builder::invocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationType").build()}).build();
    private static final SdkField<ActionGroupInvocationInput> ACTION_GROUP_INVOCATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionGroupInvocationInput").getter(InvocationInput.getter(InvocationInput::actionGroupInvocationInput)).setter(InvocationInput.setter(Builder::actionGroupInvocationInput)).constructor(ActionGroupInvocationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupInvocationInput").build()}).build();
    private static final SdkField<KnowledgeBaseLookupInput> KNOWLEDGE_BASE_LOOKUP_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBaseLookupInput").getter(InvocationInput.getter(InvocationInput::knowledgeBaseLookupInput)).setter(InvocationInput.setter(Builder::knowledgeBaseLookupInput)).constructor(KnowledgeBaseLookupInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseLookupInput").build()}).build();
    private static final SdkField<CodeInterpreterInvocationInput> CODE_INTERPRETER_INVOCATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("codeInterpreterInvocationInput").getter(InvocationInput.getter(InvocationInput::codeInterpreterInvocationInput)).setter(InvocationInput.setter(Builder::codeInterpreterInvocationInput)).constructor(CodeInterpreterInvocationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterInvocationInput").build()}).build();
    private static final SdkField<AgentCollaboratorInvocationInput> AGENT_COLLABORATOR_INVOCATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentCollaboratorInvocationInput").getter(InvocationInput.getter(InvocationInput::agentCollaboratorInvocationInput)).setter(InvocationInput.setter(Builder::agentCollaboratorInvocationInput)).constructor(AgentCollaboratorInvocationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboratorInvocationInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_ID_FIELD, INVOCATION_TYPE_FIELD, ACTION_GROUP_INVOCATION_INPUT_FIELD, KNOWLEDGE_BASE_LOOKUP_INPUT_FIELD, CODE_INTERPRETER_INVOCATION_INPUT_FIELD, AGENT_COLLABORATOR_INVOCATION_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvocationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String traceId;
    private final String invocationType;
    private final ActionGroupInvocationInput actionGroupInvocationInput;
    private final KnowledgeBaseLookupInput knowledgeBaseLookupInput;
    private final CodeInterpreterInvocationInput codeInterpreterInvocationInput;
    private final AgentCollaboratorInvocationInput agentCollaboratorInvocationInput;

    private InvocationInput(BuilderImpl builder) {
        this.traceId = builder.traceId;
        this.invocationType = builder.invocationType;
        this.actionGroupInvocationInput = builder.actionGroupInvocationInput;
        this.knowledgeBaseLookupInput = builder.knowledgeBaseLookupInput;
        this.codeInterpreterInvocationInput = builder.codeInterpreterInvocationInput;
        this.agentCollaboratorInvocationInput = builder.agentCollaboratorInvocationInput;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final InvocationType invocationType() {
        return InvocationType.fromValue(this.invocationType);
    }

    public final String invocationTypeAsString() {
        return this.invocationType;
    }

    public final ActionGroupInvocationInput actionGroupInvocationInput() {
        return this.actionGroupInvocationInput;
    }

    public final KnowledgeBaseLookupInput knowledgeBaseLookupInput() {
        return this.knowledgeBaseLookupInput;
    }

    public final CodeInterpreterInvocationInput codeInterpreterInvocationInput() {
        return this.codeInterpreterInvocationInput;
    }

    public final AgentCollaboratorInvocationInput agentCollaboratorInvocationInput() {
        return this.agentCollaboratorInvocationInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseLookupInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeInterpreterInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentCollaboratorInvocationInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationInput)) {
            return false;
        }
        InvocationInput other = (InvocationInput)obj;
        return Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.invocationTypeAsString(), other.invocationTypeAsString()) && Objects.equals(this.actionGroupInvocationInput(), other.actionGroupInvocationInput()) && Objects.equals(this.knowledgeBaseLookupInput(), other.knowledgeBaseLookupInput()) && Objects.equals(this.codeInterpreterInvocationInput(), other.codeInterpreterInvocationInput()) && Objects.equals(this.agentCollaboratorInvocationInput(), other.agentCollaboratorInvocationInput());
    }

    public final String toString() {
        return ToString.builder((String)"InvocationInput").add("TraceId", (Object)this.traceId()).add("InvocationType", (Object)this.invocationTypeAsString()).add("ActionGroupInvocationInput", (Object)this.actionGroupInvocationInput()).add("KnowledgeBaseLookupInput", (Object)this.knowledgeBaseLookupInput()).add("CodeInterpreterInvocationInput", (Object)this.codeInterpreterInvocationInput()).add("AgentCollaboratorInvocationInput", (Object)this.agentCollaboratorInvocationInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "invocationType": {
                return Optional.ofNullable(clazz.cast(this.invocationTypeAsString()));
            }
            case "actionGroupInvocationInput": {
                return Optional.ofNullable(clazz.cast(this.actionGroupInvocationInput()));
            }
            case "knowledgeBaseLookupInput": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseLookupInput()));
            }
            case "codeInterpreterInvocationInput": {
                return Optional.ofNullable(clazz.cast(this.codeInterpreterInvocationInput()));
            }
            case "agentCollaboratorInvocationInput": {
                return Optional.ofNullable(clazz.cast(this.agentCollaboratorInvocationInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("traceId", TRACE_ID_FIELD);
        map.put("invocationType", INVOCATION_TYPE_FIELD);
        map.put("actionGroupInvocationInput", ACTION_GROUP_INVOCATION_INPUT_FIELD);
        map.put("knowledgeBaseLookupInput", KNOWLEDGE_BASE_LOOKUP_INPUT_FIELD);
        map.put("codeInterpreterInvocationInput", CODE_INTERPRETER_INVOCATION_INPUT_FIELD);
        map.put("agentCollaboratorInvocationInput", AGENT_COLLABORATOR_INVOCATION_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationInput, T> g) {
        return obj -> g.apply((InvocationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String traceId;
        private String invocationType;
        private ActionGroupInvocationInput actionGroupInvocationInput;
        private KnowledgeBaseLookupInput knowledgeBaseLookupInput;
        private CodeInterpreterInvocationInput codeInterpreterInvocationInput;
        private AgentCollaboratorInvocationInput agentCollaboratorInvocationInput;

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationInput model) {
            this.traceId(model.traceId);
            this.invocationType(model.invocationType);
            this.actionGroupInvocationInput(model.actionGroupInvocationInput);
            this.knowledgeBaseLookupInput(model.knowledgeBaseLookupInput);
            this.codeInterpreterInvocationInput(model.codeInterpreterInvocationInput);
            this.agentCollaboratorInvocationInput(model.agentCollaboratorInvocationInput);
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getInvocationType() {
            return this.invocationType;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType == null ? null : invocationType.toString());
            return this;
        }

        public final ActionGroupInvocationInput.Builder getActionGroupInvocationInput() {
            return this.actionGroupInvocationInput != null ? this.actionGroupInvocationInput.toBuilder() : null;
        }

        public final void setActionGroupInvocationInput(ActionGroupInvocationInput.BuilderImpl actionGroupInvocationInput) {
            this.actionGroupInvocationInput = actionGroupInvocationInput != null ? actionGroupInvocationInput.build() : null;
        }

        @Override
        public final Builder actionGroupInvocationInput(ActionGroupInvocationInput actionGroupInvocationInput) {
            this.actionGroupInvocationInput = actionGroupInvocationInput;
            return this;
        }

        public final KnowledgeBaseLookupInput.Builder getKnowledgeBaseLookupInput() {
            return this.knowledgeBaseLookupInput != null ? this.knowledgeBaseLookupInput.toBuilder() : null;
        }

        public final void setKnowledgeBaseLookupInput(KnowledgeBaseLookupInput.BuilderImpl knowledgeBaseLookupInput) {
            this.knowledgeBaseLookupInput = knowledgeBaseLookupInput != null ? knowledgeBaseLookupInput.build() : null;
        }

        @Override
        public final Builder knowledgeBaseLookupInput(KnowledgeBaseLookupInput knowledgeBaseLookupInput) {
            this.knowledgeBaseLookupInput = knowledgeBaseLookupInput;
            return this;
        }

        public final CodeInterpreterInvocationInput.Builder getCodeInterpreterInvocationInput() {
            return this.codeInterpreterInvocationInput != null ? this.codeInterpreterInvocationInput.toBuilder() : null;
        }

        public final void setCodeInterpreterInvocationInput(CodeInterpreterInvocationInput.BuilderImpl codeInterpreterInvocationInput) {
            this.codeInterpreterInvocationInput = codeInterpreterInvocationInput != null ? codeInterpreterInvocationInput.build() : null;
        }

        @Override
        public final Builder codeInterpreterInvocationInput(CodeInterpreterInvocationInput codeInterpreterInvocationInput) {
            this.codeInterpreterInvocationInput = codeInterpreterInvocationInput;
            return this;
        }

        public final AgentCollaboratorInvocationInput.Builder getAgentCollaboratorInvocationInput() {
            return this.agentCollaboratorInvocationInput != null ? this.agentCollaboratorInvocationInput.toBuilder() : null;
        }

        public final void setAgentCollaboratorInvocationInput(AgentCollaboratorInvocationInput.BuilderImpl agentCollaboratorInvocationInput) {
            this.agentCollaboratorInvocationInput = agentCollaboratorInvocationInput != null ? agentCollaboratorInvocationInput.build() : null;
        }

        @Override
        public final Builder agentCollaboratorInvocationInput(AgentCollaboratorInvocationInput agentCollaboratorInvocationInput) {
            this.agentCollaboratorInvocationInput = agentCollaboratorInvocationInput;
            return this;
        }

        public InvocationInput build() {
            return new InvocationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvocationInput> {
        public Builder traceId(String var1);

        public Builder invocationType(String var1);

        public Builder invocationType(InvocationType var1);

        public Builder actionGroupInvocationInput(ActionGroupInvocationInput var1);

        default public Builder actionGroupInvocationInput(Consumer<ActionGroupInvocationInput.Builder> actionGroupInvocationInput) {
            return this.actionGroupInvocationInput((ActionGroupInvocationInput)((ActionGroupInvocationInput.Builder)ActionGroupInvocationInput.builder().applyMutation(actionGroupInvocationInput)).build());
        }

        public Builder knowledgeBaseLookupInput(KnowledgeBaseLookupInput var1);

        default public Builder knowledgeBaseLookupInput(Consumer<KnowledgeBaseLookupInput.Builder> knowledgeBaseLookupInput) {
            return this.knowledgeBaseLookupInput((KnowledgeBaseLookupInput)((KnowledgeBaseLookupInput.Builder)KnowledgeBaseLookupInput.builder().applyMutation(knowledgeBaseLookupInput)).build());
        }

        public Builder codeInterpreterInvocationInput(CodeInterpreterInvocationInput var1);

        default public Builder codeInterpreterInvocationInput(Consumer<CodeInterpreterInvocationInput.Builder> codeInterpreterInvocationInput) {
            return this.codeInterpreterInvocationInput((CodeInterpreterInvocationInput)((CodeInterpreterInvocationInput.Builder)CodeInterpreterInvocationInput.builder().applyMutation(codeInterpreterInvocationInput)).build());
        }

        public Builder agentCollaboratorInvocationInput(AgentCollaboratorInvocationInput var1);

        default public Builder agentCollaboratorInvocationInput(Consumer<AgentCollaboratorInvocationInput.Builder> agentCollaboratorInvocationInput) {
            return this.agentCollaboratorInvocationInput((AgentCollaboratorInvocationInput)((AgentCollaboratorInvocationInput.Builder)AgentCollaboratorInvocationInput.builder().applyMutation(agentCollaboratorInvocationInput)).build());
        }
    }
}

