/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.QueryTransformationMode;
import software.amazon.awssdk.services.bedrockagentruntime.model.TextToSqlConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformationConfiguration> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(TransformationConfiguration.getter(TransformationConfiguration::modeAsString)).setter(TransformationConfiguration.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<TextToSqlConfiguration> TEXT_TO_SQL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("textToSqlConfiguration").getter(TransformationConfiguration.getter(TransformationConfiguration::textToSqlConfiguration)).setter(TransformationConfiguration.setter(Builder::textToSqlConfiguration)).constructor(TextToSqlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textToSqlConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, TEXT_TO_SQL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransformationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final TextToSqlConfiguration textToSqlConfiguration;

    private TransformationConfiguration(BuilderImpl builder) {
        this.mode = builder.mode;
        this.textToSqlConfiguration = builder.textToSqlConfiguration;
    }

    public final QueryTransformationMode mode() {
        return QueryTransformationMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final TextToSqlConfiguration textToSqlConfiguration() {
        return this.textToSqlConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.textToSqlConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformationConfiguration)) {
            return false;
        }
        TransformationConfiguration other = (TransformationConfiguration)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.textToSqlConfiguration(), other.textToSqlConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TransformationConfiguration").add("Mode", (Object)this.modeAsString()).add("TextToSqlConfiguration", (Object)this.textToSqlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "textToSqlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.textToSqlConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mode", MODE_FIELD);
        map.put("textToSqlConfiguration", TEXT_TO_SQL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformationConfiguration, T> g) {
        return obj -> g.apply((TransformationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private TextToSqlConfiguration textToSqlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformationConfiguration model) {
            this.mode(model.mode);
            this.textToSqlConfiguration(model.textToSqlConfiguration);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(QueryTransformationMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final TextToSqlConfiguration.Builder getTextToSqlConfiguration() {
            return this.textToSqlConfiguration != null ? this.textToSqlConfiguration.toBuilder() : null;
        }

        public final void setTextToSqlConfiguration(TextToSqlConfiguration.BuilderImpl textToSqlConfiguration) {
            this.textToSqlConfiguration = textToSqlConfiguration != null ? textToSqlConfiguration.build() : null;
        }

        @Override
        public final Builder textToSqlConfiguration(TextToSqlConfiguration textToSqlConfiguration) {
            this.textToSqlConfiguration = textToSqlConfiguration;
            return this;
        }

        public TransformationConfiguration build() {
            return new TransformationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformationConfiguration> {
        public Builder mode(String var1);

        public Builder mode(QueryTransformationMode var1);

        public Builder textToSqlConfiguration(TextToSqlConfiguration var1);

        default public Builder textToSqlConfiguration(Consumer<TextToSqlConfiguration.Builder> textToSqlConfiguration) {
            return this.textToSqlConfiguration((TextToSqlConfiguration)((TextToSqlConfiguration.Builder)TextToSqlConfiguration.builder().applyMutation(textToSqlConfiguration)).build());
        }
    }
}

