/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowExecutionEventsRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, ListFlowExecutionEventsRequest> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(ListFlowExecutionEventsRequest.getter(ListFlowExecutionEventsRequest::eventTypeAsString)).setter(ListFlowExecutionEventsRequest.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("eventType").build()}).build();
    private static final SdkField<String> EXECUTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionIdentifier").getter(ListFlowExecutionEventsRequest.getter(ListFlowExecutionEventsRequest::executionIdentifier)).setter(ListFlowExecutionEventsRequest.setter(Builder::executionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("executionIdentifier").build()}).build();
    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowAliasIdentifier").getter(ListFlowExecutionEventsRequest.getter(ListFlowExecutionEventsRequest::flowAliasIdentifier)).setter(ListFlowExecutionEventsRequest.setter(Builder::flowAliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowAliasIdentifier").build()}).build();
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(ListFlowExecutionEventsRequest.getter(ListFlowExecutionEventsRequest::flowIdentifier)).setter(ListFlowExecutionEventsRequest.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListFlowExecutionEventsRequest.getter(ListFlowExecutionEventsRequest::maxResults)).setter(ListFlowExecutionEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFlowExecutionEventsRequest.getter(ListFlowExecutionEventsRequest::nextToken)).setter(ListFlowExecutionEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, EXECUTION_IDENTIFIER_FIELD, FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFlowExecutionEventsRequest.memberNameToFieldInitializer();
    private final String eventType;
    private final String executionIdentifier;
    private final String flowAliasIdentifier;
    private final String flowIdentifier;
    private final Integer maxResults;
    private final String nextToken;

    private ListFlowExecutionEventsRequest(BuilderImpl builder) {
        super(builder);
        this.eventType = builder.eventType;
        this.executionIdentifier = builder.executionIdentifier;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final FlowExecutionEventType eventType() {
        return FlowExecutionEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final String executionIdentifier() {
        return this.executionIdentifier;
    }

    public final String flowAliasIdentifier() {
        return this.flowAliasIdentifier;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowExecutionEventsRequest)) {
            return false;
        }
        ListFlowExecutionEventsRequest other = (ListFlowExecutionEventsRequest)((Object)obj);
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.executionIdentifier(), other.executionIdentifier()) && Objects.equals(this.flowAliasIdentifier(), other.flowAliasIdentifier()) && Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFlowExecutionEventsRequest").add("EventType", (Object)this.eventTypeAsString()).add("ExecutionIdentifier", (Object)this.executionIdentifier()).add("FlowAliasIdentifier", (Object)this.flowAliasIdentifier()).add("FlowIdentifier", (Object)this.flowIdentifier()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "executionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.executionIdentifier()));
            }
            case "flowAliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowAliasIdentifier()));
            }
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("executionIdentifier", EXECUTION_IDENTIFIER_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowExecutionEventsRequest, T> g) {
        return obj -> g.apply((ListFlowExecutionEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String eventType;
        private String executionIdentifier;
        private String flowAliasIdentifier;
        private String flowIdentifier;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowExecutionEventsRequest model) {
            super(model);
            this.eventType(model.eventType);
            this.executionIdentifier(model.executionIdentifier);
            this.flowAliasIdentifier(model.flowAliasIdentifier);
            this.flowIdentifier(model.flowIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(FlowExecutionEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getExecutionIdentifier() {
            return this.executionIdentifier;
        }

        public final void setExecutionIdentifier(String executionIdentifier) {
            this.executionIdentifier = executionIdentifier;
        }

        @Override
        public final Builder executionIdentifier(String executionIdentifier) {
            this.executionIdentifier = executionIdentifier;
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return this.flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFlowExecutionEventsRequest build() {
            return new ListFlowExecutionEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowExecutionEventsRequest> {
        public Builder eventType(String var1);

        public Builder eventType(FlowExecutionEventType var1);

        public Builder executionIdentifier(String var1);

        public Builder flowAliasIdentifier(String var1);

        public Builder flowIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

