/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvocationStepSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvocationStepSummary> {
    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationId").getter(InvocationStepSummary.getter(InvocationStepSummary::invocationId)).setter(InvocationStepSummary.setter(Builder::invocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()}).build();
    private static final SdkField<String> INVOCATION_STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationStepId").getter(InvocationStepSummary.getter(InvocationStepSummary::invocationStepId)).setter(InvocationStepSummary.setter(Builder::invocationStepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationStepId").build()}).build();
    private static final SdkField<Instant> INVOCATION_STEP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("invocationStepTime").getter(InvocationStepSummary.getter(InvocationStepSummary::invocationStepTime)).setter(InvocationStepSummary.setter(Builder::invocationStepTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationStepTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(InvocationStepSummary.getter(InvocationStepSummary::sessionId)).setter(InvocationStepSummary.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_ID_FIELD, INVOCATION_STEP_ID_FIELD, INVOCATION_STEP_TIME_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvocationStepSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String invocationId;
    private final String invocationStepId;
    private final Instant invocationStepTime;
    private final String sessionId;

    private InvocationStepSummary(BuilderImpl builder) {
        this.invocationId = builder.invocationId;
        this.invocationStepId = builder.invocationStepId;
        this.invocationStepTime = builder.invocationStepTime;
        this.sessionId = builder.sessionId;
    }

    public final String invocationId() {
        return this.invocationId;
    }

    public final String invocationStepId() {
        return this.invocationStepId;
    }

    public final Instant invocationStepTime() {
        return this.invocationStepTime;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationStepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationStepTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationStepSummary)) {
            return false;
        }
        InvocationStepSummary other = (InvocationStepSummary)obj;
        return Objects.equals(this.invocationId(), other.invocationId()) && Objects.equals(this.invocationStepId(), other.invocationStepId()) && Objects.equals(this.invocationStepTime(), other.invocationStepTime()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"InvocationStepSummary").add("InvocationId", (Object)this.invocationId()).add("InvocationStepId", (Object)this.invocationStepId()).add("InvocationStepTime", (Object)this.invocationStepTime()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invocationId": {
                return Optional.ofNullable(clazz.cast(this.invocationId()));
            }
            case "invocationStepId": {
                return Optional.ofNullable(clazz.cast(this.invocationStepId()));
            }
            case "invocationStepTime": {
                return Optional.ofNullable(clazz.cast(this.invocationStepTime()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invocationId", INVOCATION_ID_FIELD);
        map.put("invocationStepId", INVOCATION_STEP_ID_FIELD);
        map.put("invocationStepTime", INVOCATION_STEP_TIME_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationStepSummary, T> g) {
        return obj -> g.apply((InvocationStepSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String invocationId;
        private String invocationStepId;
        private Instant invocationStepTime;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationStepSummary model) {
            this.invocationId(model.invocationId);
            this.invocationStepId(model.invocationStepId);
            this.invocationStepTime(model.invocationStepTime);
            this.sessionId(model.sessionId);
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final String getInvocationStepId() {
            return this.invocationStepId;
        }

        public final void setInvocationStepId(String invocationStepId) {
            this.invocationStepId = invocationStepId;
        }

        @Override
        public final Builder invocationStepId(String invocationStepId) {
            this.invocationStepId = invocationStepId;
            return this;
        }

        public final Instant getInvocationStepTime() {
            return this.invocationStepTime;
        }

        public final void setInvocationStepTime(Instant invocationStepTime) {
            this.invocationStepTime = invocationStepTime;
        }

        @Override
        public final Builder invocationStepTime(Instant invocationStepTime) {
            this.invocationStepTime = invocationStepTime;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public InvocationStepSummary build() {
            return new InvocationStepSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvocationStepSummary> {
        public Builder invocationId(String var1);

        public Builder invocationStepId(String var1);

        public Builder invocationStepTime(Instant var1);

        public Builder sessionId(String var1);
    }
}

