/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.Memory;

public class GetAgentMemoryIterable
implements SdkIterable<GetAgentMemoryResponse> {
    private final BedrockAgentRuntimeClient client;
    private final GetAgentMemoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAgentMemoryIterable(BedrockAgentRuntimeClient client, GetAgentMemoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAgentMemoryResponseFetcher();
    }

    public Iterator<GetAgentMemoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Memory> memoryContents() {
        Function<GetAgentMemoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.memoryContents() != null) {
                return response.memoryContents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAgentMemoryResponseFetcher
    implements SyncPageFetcher<GetAgentMemoryResponse> {
        private GetAgentMemoryResponseFetcher() {
        }

        public boolean hasNextPage(GetAgentMemoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAgentMemoryResponse nextPage(GetAgentMemoryResponse previousPage) {
            if (previousPage == null) {
                return GetAgentMemoryIterable.this.client.getAgentMemory(GetAgentMemoryIterable.this.firstRequest);
            }
            return GetAgentMemoryIterable.this.client.getAgentMemory((GetAgentMemoryRequest)((Object)GetAgentMemoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

