/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockagentruntime.model.FilePart;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.PayloadPart;
import software.amazon.awssdk.services.bedrockagentruntime.model.ResponseStream;
import software.amazon.awssdk.services.bedrockagentruntime.model.ReturnControlPayload;
import software.amazon.awssdk.services.bedrockagentruntime.model.TracePart;

@SdkInternalApi
final class DefaultInvokeAgentVisitorBuilder
implements InvokeAgentResponseHandler.Visitor.Builder {
    private Consumer<ResponseStream> onDefault;
    private Consumer<PayloadPart> onChunk;
    private Consumer<FilePart> onFiles;
    private Consumer<ReturnControlPayload> onReturnControl;
    private Consumer<TracePart> onTrace;

    DefaultInvokeAgentVisitorBuilder() {
    }

    @Override
    public InvokeAgentResponseHandler.Visitor.Builder onDefault(Consumer<ResponseStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public InvokeAgentResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public InvokeAgentResponseHandler.Visitor.Builder onChunk(Consumer<PayloadPart> c) {
        this.onChunk = c;
        return this;
    }

    @Override
    public InvokeAgentResponseHandler.Visitor.Builder onFiles(Consumer<FilePart> c) {
        this.onFiles = c;
        return this;
    }

    @Override
    public InvokeAgentResponseHandler.Visitor.Builder onReturnControl(Consumer<ReturnControlPayload> c) {
        this.onReturnControl = c;
        return this;
    }

    @Override
    public InvokeAgentResponseHandler.Visitor.Builder onTrace(Consumer<TracePart> c) {
        this.onTrace = c;
        return this;
    }

    static class VisitorFromBuilder
    implements InvokeAgentResponseHandler.Visitor {
        private final Consumer<ResponseStream> onDefault;
        private final Consumer<PayloadPart> onChunk;
        private final Consumer<FilePart> onFiles;
        private final Consumer<ReturnControlPayload> onReturnControl;
        private final Consumer<TracePart> onTrace;

        VisitorFromBuilder(DefaultInvokeAgentVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault : x$0 -> InvokeAgentResponseHandler.Visitor.super.visitDefault((ResponseStream)x$0);
            this.onChunk = builder.onChunk != null ? builder.onChunk : x$0 -> InvokeAgentResponseHandler.Visitor.super.visitChunk((PayloadPart)x$0);
            this.onFiles = builder.onFiles != null ? builder.onFiles : x$0 -> InvokeAgentResponseHandler.Visitor.super.visitFiles((FilePart)x$0);
            this.onReturnControl = builder.onReturnControl != null ? builder.onReturnControl : x$0 -> InvokeAgentResponseHandler.Visitor.super.visitReturnControl((ReturnControlPayload)x$0);
            this.onTrace = builder.onTrace != null ? builder.onTrace : x$0 -> InvokeAgentResponseHandler.Visitor.super.visitTrace((TracePart)x$0);
        }

        @Override
        public void visitDefault(ResponseStream event) {
            this.onDefault.accept(event);
        }

        @Override
        public void visitChunk(PayloadPart event) {
            this.onChunk.accept(event);
        }

        @Override
        public void visitFiles(FilePart event) {
            this.onFiles.accept(event);
        }

        @Override
        public void visitReturnControl(ReturnControlPayload event) {
            this.onReturnControl.accept(event);
        }

        @Override
        public void visitTrace(TracePart event) {
            this.onTrace.accept(event);
        }
    }
}

