/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowInputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeFlowRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeFlowRequest> {
    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowAliasIdentifier").getter(InvokeFlowRequest.getter(InvokeFlowRequest::flowAliasIdentifier)).setter(InvokeFlowRequest.setter(Builder::flowAliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowAliasIdentifier").build()}).build();
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(InvokeFlowRequest.getter(InvokeFlowRequest::flowIdentifier)).setter(InvokeFlowRequest.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()}).build();
    private static final SdkField<List<FlowInput>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputs").getter(InvokeFlowRequest.getter(InvokeFlowRequest::inputs)).setter(InvokeFlowRequest.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_IDENTIFIER_FIELD, INPUTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
            this.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
            this.put("inputs", INPUTS_FIELD);
        }
    });
    private final String flowAliasIdentifier;
    private final String flowIdentifier;
    private final List<FlowInput> inputs;

    private InvokeFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
        this.inputs = builder.inputs;
    }

    public final String flowAliasIdentifier() {
        return this.flowAliasIdentifier;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<FlowInput> inputs() {
        return this.inputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeFlowRequest)) {
            return false;
        }
        InvokeFlowRequest other = (InvokeFlowRequest)((Object)obj);
        return Objects.equals(this.flowAliasIdentifier(), other.flowAliasIdentifier()) && Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeFlowRequest").add("FlowAliasIdentifier", (Object)this.flowAliasIdentifier()).add("FlowIdentifier", (Object)this.flowIdentifier()).add("Inputs", this.hasInputs() ? this.inputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowAliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowAliasIdentifier()));
            }
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvokeFlowRequest, T> g) {
        return obj -> g.apply((InvokeFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String flowAliasIdentifier;
        private String flowIdentifier;
        private List<FlowInput> inputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeFlowRequest model) {
            super(model);
            this.flowAliasIdentifier(model.flowAliasIdentifier);
            this.flowIdentifier(model.flowIdentifier);
            this.inputs(model.inputs);
        }

        public final String getFlowAliasIdentifier() {
            return this.flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final List<FlowInput.Builder> getInputs() {
            List<FlowInput.Builder> result = FlowInputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<FlowInput.BuilderImpl> inputs) {
            this.inputs = FlowInputsCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<FlowInput> inputs) {
            this.inputs = FlowInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(FlowInput ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<FlowInput.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (FlowInput)((FlowInput.Builder)FlowInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeFlowRequest build() {
            return new InvokeFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeFlowRequest> {
        public Builder flowAliasIdentifier(String var1);

        public Builder flowIdentifier(String var1);

        public Builder inputs(Collection<FlowInput> var1);

        public Builder inputs(FlowInput ... var1);

        public Builder inputs(Consumer<FlowInput.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

