/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.MetadataConfigurationForReranking;
import software.amazon.awssdk.services.bedrockagentruntime.model.VectorSearchBedrockRerankingModelConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VectorSearchBedrockRerankingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VectorSearchBedrockRerankingConfiguration> {
    private static final SdkField<MetadataConfigurationForReranking> METADATA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadataConfiguration").getter(VectorSearchBedrockRerankingConfiguration.getter(VectorSearchBedrockRerankingConfiguration::metadataConfiguration)).setter(VectorSearchBedrockRerankingConfiguration.setter(Builder::metadataConfiguration)).constructor(MetadataConfigurationForReranking::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataConfiguration").build()}).build();
    private static final SdkField<VectorSearchBedrockRerankingModelConfiguration> MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelConfiguration").getter(VectorSearchBedrockRerankingConfiguration.getter(VectorSearchBedrockRerankingConfiguration::modelConfiguration)).setter(VectorSearchBedrockRerankingConfiguration.setter(Builder::modelConfiguration)).constructor(VectorSearchBedrockRerankingModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelConfiguration").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RERANKED_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfRerankedResults").getter(VectorSearchBedrockRerankingConfiguration.getter(VectorSearchBedrockRerankingConfiguration::numberOfRerankedResults)).setter(VectorSearchBedrockRerankingConfiguration.setter(Builder::numberOfRerankedResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRerankedResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_CONFIGURATION_FIELD, MODEL_CONFIGURATION_FIELD, NUMBER_OF_RERANKED_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("metadataConfiguration", METADATA_CONFIGURATION_FIELD);
            this.put("modelConfiguration", MODEL_CONFIGURATION_FIELD);
            this.put("numberOfRerankedResults", NUMBER_OF_RERANKED_RESULTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final MetadataConfigurationForReranking metadataConfiguration;
    private final VectorSearchBedrockRerankingModelConfiguration modelConfiguration;
    private final Integer numberOfRerankedResults;

    private VectorSearchBedrockRerankingConfiguration(BuilderImpl builder) {
        this.metadataConfiguration = builder.metadataConfiguration;
        this.modelConfiguration = builder.modelConfiguration;
        this.numberOfRerankedResults = builder.numberOfRerankedResults;
    }

    public final MetadataConfigurationForReranking metadataConfiguration() {
        return this.metadataConfiguration;
    }

    public final VectorSearchBedrockRerankingModelConfiguration modelConfiguration() {
        return this.modelConfiguration;
    }

    public final Integer numberOfRerankedResults() {
        return this.numberOfRerankedResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRerankedResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorSearchBedrockRerankingConfiguration)) {
            return false;
        }
        VectorSearchBedrockRerankingConfiguration other = (VectorSearchBedrockRerankingConfiguration)obj;
        return Objects.equals(this.metadataConfiguration(), other.metadataConfiguration()) && Objects.equals(this.modelConfiguration(), other.modelConfiguration()) && Objects.equals(this.numberOfRerankedResults(), other.numberOfRerankedResults());
    }

    public final String toString() {
        return ToString.builder((String)"VectorSearchBedrockRerankingConfiguration").add("MetadataConfiguration", (Object)this.metadataConfiguration()).add("ModelConfiguration", (Object)this.modelConfiguration()).add("NumberOfRerankedResults", (Object)this.numberOfRerankedResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadataConfiguration": {
                return Optional.ofNullable(clazz.cast(this.metadataConfiguration()));
            }
            case "modelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.modelConfiguration()));
            }
            case "numberOfRerankedResults": {
                return Optional.ofNullable(clazz.cast(this.numberOfRerankedResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VectorSearchBedrockRerankingConfiguration, T> g) {
        return obj -> g.apply((VectorSearchBedrockRerankingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MetadataConfigurationForReranking metadataConfiguration;
        private VectorSearchBedrockRerankingModelConfiguration modelConfiguration;
        private Integer numberOfRerankedResults;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorSearchBedrockRerankingConfiguration model) {
            this.metadataConfiguration(model.metadataConfiguration);
            this.modelConfiguration(model.modelConfiguration);
            this.numberOfRerankedResults(model.numberOfRerankedResults);
        }

        public final MetadataConfigurationForReranking.Builder getMetadataConfiguration() {
            return this.metadataConfiguration != null ? this.metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(MetadataConfigurationForReranking.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(MetadataConfigurationForReranking metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        public final VectorSearchBedrockRerankingModelConfiguration.Builder getModelConfiguration() {
            return this.modelConfiguration != null ? this.modelConfiguration.toBuilder() : null;
        }

        public final void setModelConfiguration(VectorSearchBedrockRerankingModelConfiguration.BuilderImpl modelConfiguration) {
            this.modelConfiguration = modelConfiguration != null ? modelConfiguration.build() : null;
        }

        @Override
        public final Builder modelConfiguration(VectorSearchBedrockRerankingModelConfiguration modelConfiguration) {
            this.modelConfiguration = modelConfiguration;
            return this;
        }

        public final Integer getNumberOfRerankedResults() {
            return this.numberOfRerankedResults;
        }

        public final void setNumberOfRerankedResults(Integer numberOfRerankedResults) {
            this.numberOfRerankedResults = numberOfRerankedResults;
        }

        @Override
        public final Builder numberOfRerankedResults(Integer numberOfRerankedResults) {
            this.numberOfRerankedResults = numberOfRerankedResults;
            return this;
        }

        public VectorSearchBedrockRerankingConfiguration build() {
            return new VectorSearchBedrockRerankingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VectorSearchBedrockRerankingConfiguration> {
        public Builder metadataConfiguration(MetadataConfigurationForReranking var1);

        default public Builder metadataConfiguration(Consumer<MetadataConfigurationForReranking.Builder> metadataConfiguration) {
            return this.metadataConfiguration((MetadataConfigurationForReranking)((MetadataConfigurationForReranking.Builder)MetadataConfigurationForReranking.builder().applyMutation(metadataConfiguration)).build());
        }

        public Builder modelConfiguration(VectorSearchBedrockRerankingModelConfiguration var1);

        default public Builder modelConfiguration(Consumer<VectorSearchBedrockRerankingModelConfiguration.Builder> modelConfiguration) {
            return this.modelConfiguration((VectorSearchBedrockRerankingModelConfiguration)((VectorSearchBedrockRerankingModelConfiguration.Builder)VectorSearchBedrockRerankingModelConfiguration.builder().applyMutation(modelConfiguration)).build());
        }

        public Builder numberOfRerankedResults(Integer var1);
    }
}

