/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentFilePart;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentPayloadPart;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentReturnControlPayload;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentTracePart;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.inlineagentresponsestream.DefaultChunk;
import software.amazon.awssdk.services.bedrockagentruntime.model.inlineagentresponsestream.DefaultFiles;
import software.amazon.awssdk.services.bedrockagentruntime.model.inlineagentresponsestream.DefaultReturnControl;
import software.amazon.awssdk.services.bedrockagentruntime.model.inlineagentresponsestream.DefaultTrace;
import software.amazon.awssdk.utils.internal.EnumUtils;

@SdkPublicApi
public interface InlineAgentResponseStream
extends SdkPojo {
    public static final InlineAgentResponseStream UNKNOWN = new InlineAgentResponseStream(){

        public List<SdkField<?>> sdkFields() {
            return Collections.emptyList();
        }

        @Override
        public void accept(InvokeInlineAgentResponseHandler.Visitor visitor) {
            visitor.visitDefault(this);
        }
    };

    public static InlineAgentPayloadPart.Builder chunkBuilder() {
        return DefaultChunk.builder();
    }

    public static InlineAgentFilePart.Builder filesBuilder() {
        return DefaultFiles.builder();
    }

    public static InlineAgentReturnControlPayload.Builder returnControlBuilder() {
        return DefaultReturnControl.builder();
    }

    public static InlineAgentTracePart.Builder traceBuilder() {
        return DefaultTrace.builder();
    }

    default public EventType sdkEventType() {
        return EventType.UNKNOWN_TO_SDK_VERSION;
    }

    public void accept(InvokeInlineAgentResponseHandler.Visitor var1);

    public static enum EventType {
        CHUNK("chunk"),
        FILES("files"),
        RETURN_CONTROL("returnControl"),
        TRACE("trace"),
        UNKNOWN_TO_SDK_VERSION(null);

        private static final Map<String, EventType> VALUE_MAP;
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventType fromValue(String value) {
            if (value == null) {
                return null;
            }
            return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
        }

        public static Set<EventType> knownValues() {
            EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
            knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
            return knownValues;
        }

        static {
            VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
        }
    }
}

