/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowOutputContent;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowResponseStream;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeFlowResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FlowOutputEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowOutputEvent>,
FlowResponseStream {
    private static final SdkField<FlowOutputContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(FlowOutputEvent.getter(FlowOutputEvent::content)).setter(FlowOutputEvent.setter(Builder::content)).constructor(FlowOutputContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(FlowOutputEvent.getter(FlowOutputEvent::nodeName)).setter(FlowOutputEvent.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeType").getter(FlowOutputEvent.getter(FlowOutputEvent::nodeTypeAsString)).setter(FlowOutputEvent.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, NODE_NAME_FIELD, NODE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("content", CONTENT_FIELD);
            this.put("nodeName", NODE_NAME_FIELD);
            this.put("nodeType", NODE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final FlowOutputContent content;
    private final String nodeName;
    private final String nodeType;

    protected FlowOutputEvent(BuilderImpl builder) {
        this.content = builder.content;
        this.nodeName = builder.nodeName;
        this.nodeType = builder.nodeType;
    }

    public final FlowOutputContent content() {
        return this.content;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final NodeType nodeType() {
        return NodeType.fromValue(this.nodeType);
    }

    public final String nodeTypeAsString() {
        return this.nodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowOutputEvent)) {
            return false;
        }
        FlowOutputEvent other = (FlowOutputEvent)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.nodeTypeAsString(), other.nodeTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlowOutputEvent").add("Content", (Object)this.content()).add("NodeName", (Object)this.nodeName()).add("NodeType", (Object)this.nodeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "nodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final FlowOutputEvent copy(Consumer<? super Builder> modifier) {
        return (FlowOutputEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FlowOutputEvent, T> g) {
        return obj -> g.apply((FlowOutputEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(InvokeFlowResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private FlowOutputContent content;
        private String nodeName;
        private String nodeType;

        protected BuilderImpl() {
        }

        protected BuilderImpl(FlowOutputEvent model) {
            this.content(model.content);
            this.nodeName(model.nodeName);
            this.nodeType(model.nodeType);
        }

        public final FlowOutputContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(FlowOutputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowOutputContent content) {
            this.content = content;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(NodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        public FlowOutputEvent build() {
            return new FlowOutputEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowOutputEvent> {
        public Builder content(FlowOutputContent var1);

        default public Builder content(Consumer<FlowOutputContent.Builder> content) {
            return this.content((FlowOutputContent)((FlowOutputContent.Builder)FlowOutputContent.builder().applyMutation(content)).build());
        }

        public Builder nodeName(String var1);

        public Builder nodeType(String var1);

        public Builder nodeType(NodeType var1);
    }
}

