/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAgentMemoryRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<DeleteAgentMemoryRequest.Builder, DeleteAgentMemoryRequest> {
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasId").getter(getter(DeleteAgentMemoryRequest::agentAliasId))
            .setter(setter(Builder::agentAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentAliasId").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(DeleteAgentMemoryRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryId").getter(getter(DeleteAgentMemoryRequest::memoryId)).setter(setter(Builder::memoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("memoryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_ID_FIELD,
            AGENT_ID_FIELD, MEMORY_ID_FIELD));

    private final String agentAliasId;

    private final String agentId;

    private final String memoryId;

    private DeleteAgentMemoryRequest(BuilderImpl builder) {
        super(builder);
        this.agentAliasId = builder.agentAliasId;
        this.agentId = builder.agentId;
        this.memoryId = builder.memoryId;
    }

    /**
     * <p>
     * The unique identifier of an alias of an agent.
     * </p>
     * 
     * @return The unique identifier of an alias of an agent.
     */
    public final String agentAliasId() {
        return agentAliasId;
    }

    /**
     * <p>
     * The unique identifier of the agent to which the alias belongs.
     * </p>
     * 
     * @return The unique identifier of the agent to which the alias belongs.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The unique identifier of the memory.
     * </p>
     * 
     * @return The unique identifier of the memory.
     */
    public final String memoryId() {
        return memoryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(memoryId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAgentMemoryRequest)) {
            return false;
        }
        DeleteAgentMemoryRequest other = (DeleteAgentMemoryRequest) obj;
        return Objects.equals(agentAliasId(), other.agentAliasId()) && Objects.equals(agentId(), other.agentId())
                && Objects.equals(memoryId(), other.memoryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAgentMemoryRequest").add("AgentAliasId", agentAliasId()).add("AgentId", agentId())
                .add("MemoryId", memoryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentAliasId":
            return Optional.ofNullable(clazz.cast(agentAliasId()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "memoryId":
            return Optional.ofNullable(clazz.cast(memoryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAgentMemoryRequest, T> g) {
        return obj -> g.apply((DeleteAgentMemoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAgentMemoryRequest> {
        /**
         * <p>
         * The unique identifier of an alias of an agent.
         * </p>
         * 
         * @param agentAliasId
         *        The unique identifier of an alias of an agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasId(String agentAliasId);

        /**
         * <p>
         * The unique identifier of the agent to which the alias belongs.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent to which the alias belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The unique identifier of the memory.
         * </p>
         * 
         * @param memoryId
         *        The unique identifier of the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryId(String memoryId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String agentAliasId;

        private String agentId;

        private String memoryId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAgentMemoryRequest model) {
            super(model);
            agentAliasId(model.agentAliasId);
            agentId(model.agentId);
            memoryId(model.memoryId);
        }

        public final String getAgentAliasId() {
            return agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getMemoryId() {
            return memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAgentMemoryRequest build() {
            return new DeleteAgentMemoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
