/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.ExternalSource;
import software.amazon.awssdk.services.bedrockagentruntime.model.ExternalSourcesCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.ExternalSourcesGenerationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalSourcesRetrieveAndGenerateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalSourcesRetrieveAndGenerateConfiguration> {
    private static final SdkField<ExternalSourcesGenerationConfiguration> GENERATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generationConfiguration").getter(ExternalSourcesRetrieveAndGenerateConfiguration.getter(ExternalSourcesRetrieveAndGenerateConfiguration::generationConfiguration)).setter(ExternalSourcesRetrieveAndGenerateConfiguration.setter(Builder::generationConfiguration)).constructor(ExternalSourcesGenerationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationConfiguration").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(ExternalSourcesRetrieveAndGenerateConfiguration.getter(ExternalSourcesRetrieveAndGenerateConfiguration::modelArn)).setter(ExternalSourcesRetrieveAndGenerateConfiguration.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<List<ExternalSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(ExternalSourcesRetrieveAndGenerateConfiguration.getter(ExternalSourcesRetrieveAndGenerateConfiguration::sources)).setter(ExternalSourcesRetrieveAndGenerateConfiguration.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExternalSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_CONFIGURATION_FIELD, MODEL_ARN_FIELD, SOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final ExternalSourcesGenerationConfiguration generationConfiguration;
    private final String modelArn;
    private final List<ExternalSource> sources;

    private ExternalSourcesRetrieveAndGenerateConfiguration(BuilderImpl builder) {
        this.generationConfiguration = builder.generationConfiguration;
        this.modelArn = builder.modelArn;
        this.sources = builder.sources;
    }

    public final ExternalSourcesGenerationConfiguration generationConfiguration() {
        return this.generationConfiguration;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<ExternalSource> sources() {
        return this.sources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.generationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSourcesRetrieveAndGenerateConfiguration)) {
            return false;
        }
        ExternalSourcesRetrieveAndGenerateConfiguration other = (ExternalSourcesRetrieveAndGenerateConfiguration)obj;
        return Objects.equals(this.generationConfiguration(), other.generationConfiguration()) && Objects.equals(this.modelArn(), other.modelArn()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalSourcesRetrieveAndGenerateConfiguration").add("GenerationConfiguration", (Object)this.generationConfiguration()).add("ModelArn", (Object)this.modelArn()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "generationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.generationConfiguration()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalSourcesRetrieveAndGenerateConfiguration, T> g) {
        return obj -> g.apply((ExternalSourcesRetrieveAndGenerateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExternalSourcesGenerationConfiguration generationConfiguration;
        private String modelArn;
        private List<ExternalSource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalSourcesRetrieveAndGenerateConfiguration model) {
            this.generationConfiguration(model.generationConfiguration);
            this.modelArn(model.modelArn);
            this.sources(model.sources);
        }

        public final ExternalSourcesGenerationConfiguration.Builder getGenerationConfiguration() {
            return this.generationConfiguration != null ? this.generationConfiguration.toBuilder() : null;
        }

        public final void setGenerationConfiguration(ExternalSourcesGenerationConfiguration.BuilderImpl generationConfiguration) {
            this.generationConfiguration = generationConfiguration != null ? generationConfiguration.build() : null;
        }

        @Override
        public final Builder generationConfiguration(ExternalSourcesGenerationConfiguration generationConfiguration) {
            this.generationConfiguration = generationConfiguration;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final List<ExternalSource.Builder> getSources() {
            List<ExternalSource.Builder> result = ExternalSourcesCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<ExternalSource.BuilderImpl> sources) {
            this.sources = ExternalSourcesCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<ExternalSource> sources) {
            this.sources = ExternalSourcesCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(ExternalSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<ExternalSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (ExternalSource)((ExternalSource.Builder)ExternalSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExternalSourcesRetrieveAndGenerateConfiguration build() {
            return new ExternalSourcesRetrieveAndGenerateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalSourcesRetrieveAndGenerateConfiguration> {
        public Builder generationConfiguration(ExternalSourcesGenerationConfiguration var1);

        default public Builder generationConfiguration(Consumer<ExternalSourcesGenerationConfiguration.Builder> generationConfiguration) {
            return this.generationConfiguration((ExternalSourcesGenerationConfiguration)((ExternalSourcesGenerationConfiguration.Builder)ExternalSourcesGenerationConfiguration.builder().applyMutation(generationConfiguration)).build());
        }

        public Builder modelArn(String var1);

        public Builder sources(Collection<ExternalSource> var1);

        public Builder sources(ExternalSource ... var1);

        public Builder sources(Consumer<ExternalSource.Builder> ... var1);
    }
}

