/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.FailureTrace;
import software.amazon.awssdk.services.bedrockagentruntime.model.OrchestrationTrace;
import software.amazon.awssdk.services.bedrockagentruntime.model.PostProcessingTrace;
import software.amazon.awssdk.services.bedrockagentruntime.model.PreProcessingTrace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Trace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Trace> {
    private static final SdkField<PreProcessingTrace> PRE_PROCESSING_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preProcessingTrace").getter(Trace.getter(Trace::preProcessingTrace)).setter(Trace.setter(Builder::preProcessingTrace)).constructor(PreProcessingTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preProcessingTrace").build()}).build();
    private static final SdkField<OrchestrationTrace> ORCHESTRATION_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orchestrationTrace").getter(Trace.getter(Trace::orchestrationTrace)).setter(Trace.setter(Builder::orchestrationTrace)).constructor(OrchestrationTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationTrace").build()}).build();
    private static final SdkField<PostProcessingTrace> POST_PROCESSING_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("postProcessingTrace").getter(Trace.getter(Trace::postProcessingTrace)).setter(Trace.setter(Builder::postProcessingTrace)).constructor(PostProcessingTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postProcessingTrace").build()}).build();
    private static final SdkField<FailureTrace> FAILURE_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failureTrace").getter(Trace.getter(Trace::failureTrace)).setter(Trace.setter(Builder::failureTrace)).constructor(FailureTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureTrace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRE_PROCESSING_TRACE_FIELD, ORCHESTRATION_TRACE_FIELD, POST_PROCESSING_TRACE_FIELD, FAILURE_TRACE_FIELD));
    private static final long serialVersionUID = 1L;
    private final PreProcessingTrace preProcessingTrace;
    private final OrchestrationTrace orchestrationTrace;
    private final PostProcessingTrace postProcessingTrace;
    private final FailureTrace failureTrace;
    private final Type type;

    private Trace(BuilderImpl builder) {
        this.preProcessingTrace = builder.preProcessingTrace;
        this.orchestrationTrace = builder.orchestrationTrace;
        this.postProcessingTrace = builder.postProcessingTrace;
        this.failureTrace = builder.failureTrace;
        this.type = builder.type;
    }

    public final PreProcessingTrace preProcessingTrace() {
        return this.preProcessingTrace;
    }

    public final OrchestrationTrace orchestrationTrace() {
        return this.orchestrationTrace;
    }

    public final PostProcessingTrace postProcessingTrace() {
        return this.postProcessingTrace;
    }

    public final FailureTrace failureTrace() {
        return this.failureTrace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.preProcessingTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrationTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.postProcessingTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTrace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trace)) {
            return false;
        }
        Trace other = (Trace)obj;
        return Objects.equals(this.preProcessingTrace(), other.preProcessingTrace()) && Objects.equals(this.orchestrationTrace(), other.orchestrationTrace()) && Objects.equals(this.postProcessingTrace(), other.postProcessingTrace()) && Objects.equals(this.failureTrace(), other.failureTrace());
    }

    public final String toString() {
        return ToString.builder((String)"Trace").add("PreProcessingTrace", (Object)(this.preProcessingTrace() == null ? null : "*** Sensitive Data Redacted ***")).add("OrchestrationTrace", (Object)(this.orchestrationTrace() == null ? null : "*** Sensitive Data Redacted ***")).add("PostProcessingTrace", (Object)(this.postProcessingTrace() == null ? null : "*** Sensitive Data Redacted ***")).add("FailureTrace", (Object)(this.failureTrace() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "preProcessingTrace": {
                return Optional.ofNullable(clazz.cast(this.preProcessingTrace()));
            }
            case "orchestrationTrace": {
                return Optional.ofNullable(clazz.cast(this.orchestrationTrace()));
            }
            case "postProcessingTrace": {
                return Optional.ofNullable(clazz.cast(this.postProcessingTrace()));
            }
            case "failureTrace": {
                return Optional.ofNullable(clazz.cast(this.failureTrace()));
            }
        }
        return Optional.empty();
    }

    public static Trace fromPreProcessingTrace(PreProcessingTrace preProcessingTrace) {
        return (Trace)Trace.builder().preProcessingTrace(preProcessingTrace).build();
    }

    public static Trace fromPreProcessingTrace(Consumer<PreProcessingTrace.Builder> preProcessingTrace) {
        PreProcessingTrace.Builder builder = PreProcessingTrace.builder();
        preProcessingTrace.accept(builder);
        return Trace.fromPreProcessingTrace((PreProcessingTrace)builder.build());
    }

    public static Trace fromOrchestrationTrace(OrchestrationTrace orchestrationTrace) {
        return (Trace)Trace.builder().orchestrationTrace(orchestrationTrace).build();
    }

    public static Trace fromOrchestrationTrace(Consumer<OrchestrationTrace.Builder> orchestrationTrace) {
        OrchestrationTrace.Builder builder = OrchestrationTrace.builder();
        orchestrationTrace.accept(builder);
        return Trace.fromOrchestrationTrace((OrchestrationTrace)builder.build());
    }

    public static Trace fromPostProcessingTrace(PostProcessingTrace postProcessingTrace) {
        return (Trace)Trace.builder().postProcessingTrace(postProcessingTrace).build();
    }

    public static Trace fromPostProcessingTrace(Consumer<PostProcessingTrace.Builder> postProcessingTrace) {
        PostProcessingTrace.Builder builder = PostProcessingTrace.builder();
        postProcessingTrace.accept(builder);
        return Trace.fromPostProcessingTrace((PostProcessingTrace)builder.build());
    }

    public static Trace fromFailureTrace(FailureTrace failureTrace) {
        return (Trace)Trace.builder().failureTrace(failureTrace).build();
    }

    public static Trace fromFailureTrace(Consumer<FailureTrace.Builder> failureTrace) {
        FailureTrace.Builder builder = FailureTrace.builder();
        failureTrace.accept(builder);
        return Trace.fromFailureTrace((FailureTrace)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trace, T> g) {
        return obj -> g.apply((Trace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PRE_PROCESSING_TRACE,
        ORCHESTRATION_TRACE,
        POST_PROCESSING_TRACE,
        FAILURE_TRACE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PreProcessingTrace preProcessingTrace;
        private OrchestrationTrace orchestrationTrace;
        private PostProcessingTrace postProcessingTrace;
        private FailureTrace failureTrace;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Trace model) {
            this.preProcessingTrace(model.preProcessingTrace);
            this.orchestrationTrace(model.orchestrationTrace);
            this.postProcessingTrace(model.postProcessingTrace);
            this.failureTrace(model.failureTrace);
        }

        public final PreProcessingTrace.Builder getPreProcessingTrace() {
            return this.preProcessingTrace != null ? this.preProcessingTrace.toBuilder() : null;
        }

        public final void setPreProcessingTrace(PreProcessingTrace.BuilderImpl preProcessingTrace) {
            PreProcessingTrace oldValue = this.preProcessingTrace;
            this.preProcessingTrace = preProcessingTrace != null ? preProcessingTrace.build() : null;
            this.handleUnionValueChange(Type.PRE_PROCESSING_TRACE, oldValue, this.preProcessingTrace);
        }

        @Override
        public final Builder preProcessingTrace(PreProcessingTrace preProcessingTrace) {
            PreProcessingTrace oldValue = this.preProcessingTrace;
            this.preProcessingTrace = preProcessingTrace;
            this.handleUnionValueChange(Type.PRE_PROCESSING_TRACE, oldValue, this.preProcessingTrace);
            return this;
        }

        public final OrchestrationTrace.Builder getOrchestrationTrace() {
            return this.orchestrationTrace != null ? this.orchestrationTrace.toBuilder() : null;
        }

        public final void setOrchestrationTrace(OrchestrationTrace.BuilderImpl orchestrationTrace) {
            OrchestrationTrace oldValue = this.orchestrationTrace;
            this.orchestrationTrace = orchestrationTrace != null ? orchestrationTrace.build() : null;
            this.handleUnionValueChange(Type.ORCHESTRATION_TRACE, oldValue, this.orchestrationTrace);
        }

        @Override
        public final Builder orchestrationTrace(OrchestrationTrace orchestrationTrace) {
            OrchestrationTrace oldValue = this.orchestrationTrace;
            this.orchestrationTrace = orchestrationTrace;
            this.handleUnionValueChange(Type.ORCHESTRATION_TRACE, oldValue, this.orchestrationTrace);
            return this;
        }

        public final PostProcessingTrace.Builder getPostProcessingTrace() {
            return this.postProcessingTrace != null ? this.postProcessingTrace.toBuilder() : null;
        }

        public final void setPostProcessingTrace(PostProcessingTrace.BuilderImpl postProcessingTrace) {
            PostProcessingTrace oldValue = this.postProcessingTrace;
            this.postProcessingTrace = postProcessingTrace != null ? postProcessingTrace.build() : null;
            this.handleUnionValueChange(Type.POST_PROCESSING_TRACE, oldValue, this.postProcessingTrace);
        }

        @Override
        public final Builder postProcessingTrace(PostProcessingTrace postProcessingTrace) {
            PostProcessingTrace oldValue = this.postProcessingTrace;
            this.postProcessingTrace = postProcessingTrace;
            this.handleUnionValueChange(Type.POST_PROCESSING_TRACE, oldValue, this.postProcessingTrace);
            return this;
        }

        public final FailureTrace.Builder getFailureTrace() {
            return this.failureTrace != null ? this.failureTrace.toBuilder() : null;
        }

        public final void setFailureTrace(FailureTrace.BuilderImpl failureTrace) {
            FailureTrace oldValue = this.failureTrace;
            this.failureTrace = failureTrace != null ? failureTrace.build() : null;
            this.handleUnionValueChange(Type.FAILURE_TRACE, oldValue, this.failureTrace);
        }

        @Override
        public final Builder failureTrace(FailureTrace failureTrace) {
            FailureTrace oldValue = this.failureTrace;
            this.failureTrace = failureTrace;
            this.handleUnionValueChange(Type.FAILURE_TRACE, oldValue, this.failureTrace);
            return this;
        }

        public Trace build() {
            return new Trace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Trace> {
        public Builder preProcessingTrace(PreProcessingTrace var1);

        default public Builder preProcessingTrace(Consumer<PreProcessingTrace.Builder> preProcessingTrace) {
            return this.preProcessingTrace((PreProcessingTrace)((PreProcessingTrace.Builder)PreProcessingTrace.builder().applyMutation(preProcessingTrace)).build());
        }

        public Builder orchestrationTrace(OrchestrationTrace var1);

        default public Builder orchestrationTrace(Consumer<OrchestrationTrace.Builder> orchestrationTrace) {
            return this.orchestrationTrace((OrchestrationTrace)((OrchestrationTrace.Builder)OrchestrationTrace.builder().applyMutation(orchestrationTrace)).build());
        }

        public Builder postProcessingTrace(PostProcessingTrace var1);

        default public Builder postProcessingTrace(Consumer<PostProcessingTrace.Builder> postProcessingTrace) {
            return this.postProcessingTrace((PostProcessingTrace)((PostProcessingTrace.Builder)PostProcessingTrace.builder().applyMutation(postProcessingTrace)).build());
        }

        public Builder failureTrace(FailureTrace var1);

        default public Builder failureTrace(Consumer<FailureTrace.Builder> failureTrace) {
            return this.failureTrace((FailureTrace)((FailureTrace.Builder)FailureTrace.builder().applyMutation(failureTrace)).build());
        }
    }
}

