/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.CreationMode;
import software.amazon.awssdk.services.bedrockagentruntime.model.InferenceConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelInvocationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelInvocationInput> {
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(ModelInvocationInput.getter(ModelInvocationInput::traceId)).setter(ModelInvocationInput.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ModelInvocationInput.getter(ModelInvocationInput::text)).setter(ModelInvocationInput.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ModelInvocationInput.getter(ModelInvocationInput::typeAsString)).setter(ModelInvocationInput.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<InferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfiguration").getter(ModelInvocationInput.getter(ModelInvocationInput::inferenceConfiguration)).setter(ModelInvocationInput.setter(Builder::inferenceConfiguration)).constructor(InferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build()}).build();
    private static final SdkField<String> OVERRIDE_LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideLambda").getter(ModelInvocationInput.getter(ModelInvocationInput::overrideLambda)).setter(ModelInvocationInput.setter(Builder::overrideLambda)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideLambda").build()}).build();
    private static final SdkField<String> PROMPT_CREATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptCreationMode").getter(ModelInvocationInput.getter(ModelInvocationInput::promptCreationModeAsString)).setter(ModelInvocationInput.setter(Builder::promptCreationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptCreationMode").build()}).build();
    private static final SdkField<String> PARSER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parserMode").getter(ModelInvocationInput.getter(ModelInvocationInput::parserModeAsString)).setter(ModelInvocationInput.setter(Builder::parserMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parserMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_ID_FIELD, TEXT_FIELD, TYPE_FIELD, INFERENCE_CONFIGURATION_FIELD, OVERRIDE_LAMBDA_FIELD, PROMPT_CREATION_MODE_FIELD, PARSER_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String traceId;
    private final String text;
    private final String type;
    private final InferenceConfiguration inferenceConfiguration;
    private final String overrideLambda;
    private final String promptCreationMode;
    private final String parserMode;

    private ModelInvocationInput(BuilderImpl builder) {
        this.traceId = builder.traceId;
        this.text = builder.text;
        this.type = builder.type;
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.overrideLambda = builder.overrideLambda;
        this.promptCreationMode = builder.promptCreationMode;
        this.parserMode = builder.parserMode;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final String text() {
        return this.text;
    }

    public final PromptType type() {
        return PromptType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final InferenceConfiguration inferenceConfiguration() {
        return this.inferenceConfiguration;
    }

    public final String overrideLambda() {
        return this.overrideLambda;
    }

    public final CreationMode promptCreationMode() {
        return CreationMode.fromValue(this.promptCreationMode);
    }

    public final String promptCreationModeAsString() {
        return this.promptCreationMode;
    }

    public final CreationMode parserMode() {
        return CreationMode.fromValue(this.parserMode);
    }

    public final String parserModeAsString() {
        return this.parserMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideLambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptCreationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parserModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInvocationInput)) {
            return false;
        }
        ModelInvocationInput other = (ModelInvocationInput)obj;
        return Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.inferenceConfiguration(), other.inferenceConfiguration()) && Objects.equals(this.overrideLambda(), other.overrideLambda()) && Objects.equals(this.promptCreationModeAsString(), other.promptCreationModeAsString()) && Objects.equals(this.parserModeAsString(), other.parserModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModelInvocationInput").add("TraceId", (Object)this.traceId()).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("InferenceConfiguration", (Object)this.inferenceConfiguration()).add("OverrideLambda", (Object)this.overrideLambda()).add("PromptCreationMode", (Object)this.promptCreationModeAsString()).add("ParserMode", (Object)this.parserModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "inferenceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfiguration()));
            }
            case "overrideLambda": {
                return Optional.ofNullable(clazz.cast(this.overrideLambda()));
            }
            case "promptCreationMode": {
                return Optional.ofNullable(clazz.cast(this.promptCreationModeAsString()));
            }
            case "parserMode": {
                return Optional.ofNullable(clazz.cast(this.parserModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelInvocationInput, T> g) {
        return obj -> g.apply((ModelInvocationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String traceId;
        private String text;
        private String type;
        private InferenceConfiguration inferenceConfiguration;
        private String overrideLambda;
        private String promptCreationMode;
        private String parserMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInvocationInput model) {
            this.traceId(model.traceId);
            this.text(model.text);
            this.type(model.type);
            this.inferenceConfiguration(model.inferenceConfiguration);
            this.overrideLambda(model.overrideLambda);
            this.promptCreationMode(model.promptCreationMode);
            this.parserMode(model.parserMode);
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PromptType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final InferenceConfiguration.Builder getInferenceConfiguration() {
            return this.inferenceConfiguration != null ? this.inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(InferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(InferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final String getOverrideLambda() {
            return this.overrideLambda;
        }

        public final void setOverrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
        }

        @Override
        public final Builder overrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
            return this;
        }

        public final String getPromptCreationMode() {
            return this.promptCreationMode;
        }

        public final void setPromptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
        }

        @Override
        public final Builder promptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
            return this;
        }

        @Override
        public final Builder promptCreationMode(CreationMode promptCreationMode) {
            this.promptCreationMode(promptCreationMode == null ? null : promptCreationMode.toString());
            return this;
        }

        public final String getParserMode() {
            return this.parserMode;
        }

        public final void setParserMode(String parserMode) {
            this.parserMode = parserMode;
        }

        @Override
        public final Builder parserMode(String parserMode) {
            this.parserMode = parserMode;
            return this;
        }

        @Override
        public final Builder parserMode(CreationMode parserMode) {
            this.parserMode(parserMode == null ? null : parserMode.toString());
            return this;
        }

        public ModelInvocationInput build() {
            return new ModelInvocationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelInvocationInput> {
        public Builder traceId(String var1);

        public Builder text(String var1);

        public Builder type(String var1);

        public Builder type(PromptType var1);

        public Builder inferenceConfiguration(InferenceConfiguration var1);

        default public Builder inferenceConfiguration(Consumer<InferenceConfiguration.Builder> inferenceConfiguration) {
            return this.inferenceConfiguration((InferenceConfiguration)((InferenceConfiguration.Builder)InferenceConfiguration.builder().applyMutation(inferenceConfiguration)).build());
        }

        public Builder overrideLambda(String var1);

        public Builder promptCreationMode(String var1);

        public Builder promptCreationMode(CreationMode var1);

        public Builder parserMode(String var1);

        public Builder parserMode(CreationMode var1);
    }
}

