/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Text response part
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextResponsePart implements SdkPojo, Serializable,
        ToCopyableBuilder<TextResponsePart.Builder, TextResponsePart> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(TextResponsePart::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<Span> SPAN_FIELD = SdkField.<Span> builder(MarshallingType.SDK_POJO).memberName("span")
            .getter(getter(TextResponsePart::span)).setter(setter(Builder::span)).constructor(Span::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("span").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, SPAN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String text;

    private final Span span;

    private TextResponsePart(BuilderImpl builder) {
        this.text = builder.text;
        this.span = builder.span;
    }

    /**
     * <p>
     * Response part in text
     * </p>
     * 
     * @return Response part in text
     */
    public final String text() {
        return text;
    }

    /**
     * Returns the value of the Span property for this object.
     * 
     * @return The value of the Span property for this object.
     */
    public final Span span() {
        return span;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(span());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextResponsePart)) {
            return false;
        }
        TextResponsePart other = (TextResponsePart) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(span(), other.span());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextResponsePart").add("Text", text()).add("Span", span()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "span":
            return Optional.ofNullable(clazz.cast(span()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextResponsePart, T> g) {
        return obj -> g.apply((TextResponsePart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextResponsePart> {
        /**
         * <p>
         * Response part in text
         * </p>
         * 
         * @param text
         *        Response part in text
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * Sets the value of the Span property for this object.
         *
         * @param span
         *        The new value for the Span property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder span(Span span);

        /**
         * Sets the value of the Span property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Span.Builder} avoiding the need to create
         * one manually via {@link Span#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Span.Builder#build()} is called immediately and its result is
         * passed to {@link #span(Span)}.
         * 
         * @param span
         *        a consumer that will call methods on {@link Span.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #span(Span)
         */
        default Builder span(Consumer<Span.Builder> span) {
            return span(Span.builder().applyMutation(span).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private Span span;

        private BuilderImpl() {
        }

        private BuilderImpl(TextResponsePart model) {
            text(model.text);
            span(model.span);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Span.Builder getSpan() {
            return span != null ? span.toBuilder() : null;
        }

        public final void setSpan(Span.BuilderImpl span) {
            this.span = span != null ? span.build() : null;
        }

        @Override
        public final Builder span(Span span) {
            this.span = span;
            return this;
        }

        @Override
        public TextResponsePart build() {
            return new TextResponsePart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
