/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InvocationType {
    ACTION_GROUP("ACTION_GROUP"),
    KNOWLEDGE_BASE("KNOWLEDGE_BASE"),
    FINISH("FINISH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InvocationType> VALUE_MAP;
    private final String value;

    private InvocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InvocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InvocationType> knownValues() {
        EnumSet<InvocationType> knownValues = EnumSet.allOf(InvocationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InvocationType.class, InvocationType::toString);
    }
}

