/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.FlowValidation;
import software.amazon.awssdk.services.bedrockagent.model.FlowValidationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateFlowDefinitionResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, ValidateFlowDefinitionResponse> {
    private static final SdkField<List<FlowValidation>> VALIDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validations").getter(ValidateFlowDefinitionResponse.getter(ValidateFlowDefinitionResponse::validations)).setter(ValidateFlowDefinitionResponse.setter(Builder::validations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowValidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidateFlowDefinitionResponse.memberNameToFieldInitializer();
    private final List<FlowValidation> validations;

    private ValidateFlowDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.validations = builder.validations;
    }

    public final boolean hasValidations() {
        return this.validations != null && !(this.validations instanceof SdkAutoConstructList);
    }

    public final List<FlowValidation> validations() {
        return this.validations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidations() ? this.validations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateFlowDefinitionResponse)) {
            return false;
        }
        ValidateFlowDefinitionResponse other = (ValidateFlowDefinitionResponse)((Object)obj);
        return this.hasValidations() == other.hasValidations() && Objects.equals(this.validations(), other.validations());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateFlowDefinitionResponse").add("Validations", this.hasValidations() ? this.validations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validations": {
                return Optional.ofNullable(clazz.cast(this.validations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<FlowValidation>>> map = new HashMap<String, SdkField<List<FlowValidation>>>();
        map.put("validations", VALIDATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidateFlowDefinitionResponse, T> g) {
        return obj -> g.apply((ValidateFlowDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private List<FlowValidation> validations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateFlowDefinitionResponse model) {
            super(model);
            this.validations(model.validations);
        }

        public final List<FlowValidation.Builder> getValidations() {
            List<FlowValidation.Builder> result = FlowValidationsCopier.copyToBuilder(this.validations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidations(Collection<FlowValidation.BuilderImpl> validations) {
            this.validations = FlowValidationsCopier.copyFromBuilder(validations);
        }

        @Override
        public final Builder validations(Collection<FlowValidation> validations) {
            this.validations = FlowValidationsCopier.copy(validations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(FlowValidation ... validations) {
            this.validations(Arrays.asList(validations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(Consumer<FlowValidation.Builder> ... validations) {
            this.validations(Stream.of(validations).map(c -> (FlowValidation)((FlowValidation.Builder)FlowValidation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ValidateFlowDefinitionResponse build() {
            return new ValidateFlowDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidateFlowDefinitionResponse> {
        public Builder validations(Collection<FlowValidation> var1);

        public Builder validations(FlowValidation ... var1);

        public Builder validations(Consumer<FlowValidation.Builder> ... var1);
    }
}

