/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.WebCrawlerConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.WebSourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebDataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebDataSourceConfiguration> {
    private static final SdkField<WebCrawlerConfiguration> CRAWLER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("crawlerConfiguration").getter(WebDataSourceConfiguration.getter(WebDataSourceConfiguration::crawlerConfiguration)).setter(WebDataSourceConfiguration.setter(Builder::crawlerConfiguration)).constructor(WebCrawlerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerConfiguration").build()}).build();
    private static final SdkField<WebSourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceConfiguration").getter(WebDataSourceConfiguration.getter(WebDataSourceConfiguration::sourceConfiguration)).setter(WebDataSourceConfiguration.setter(Builder::sourceConfiguration)).constructor(WebSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_CONFIGURATION_FIELD, SOURCE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WebDataSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final WebCrawlerConfiguration crawlerConfiguration;
    private final WebSourceConfiguration sourceConfiguration;

    private WebDataSourceConfiguration(BuilderImpl builder) {
        this.crawlerConfiguration = builder.crawlerConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
    }

    public final WebCrawlerConfiguration crawlerConfiguration() {
        return this.crawlerConfiguration;
    }

    public final WebSourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebDataSourceConfiguration)) {
            return false;
        }
        WebDataSourceConfiguration other = (WebDataSourceConfiguration)obj;
        return Objects.equals(this.crawlerConfiguration(), other.crawlerConfiguration()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"WebDataSourceConfiguration").add("CrawlerConfiguration", (Object)this.crawlerConfiguration()).add("SourceConfiguration", (Object)this.sourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crawlerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.crawlerConfiguration()));
            }
            case "sourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("crawlerConfiguration", CRAWLER_CONFIGURATION_FIELD);
        map.put("sourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebDataSourceConfiguration, T> g) {
        return obj -> g.apply((WebDataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WebCrawlerConfiguration crawlerConfiguration;
        private WebSourceConfiguration sourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(WebDataSourceConfiguration model) {
            this.crawlerConfiguration(model.crawlerConfiguration);
            this.sourceConfiguration(model.sourceConfiguration);
        }

        public final WebCrawlerConfiguration.Builder getCrawlerConfiguration() {
            return this.crawlerConfiguration != null ? this.crawlerConfiguration.toBuilder() : null;
        }

        public final void setCrawlerConfiguration(WebCrawlerConfiguration.BuilderImpl crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration != null ? crawlerConfiguration.build() : null;
        }

        @Override
        public final Builder crawlerConfiguration(WebCrawlerConfiguration crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration;
            return this;
        }

        public final WebSourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(WebSourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(WebSourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public WebDataSourceConfiguration build() {
            return new WebDataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebDataSourceConfiguration> {
        public Builder crawlerConfiguration(WebCrawlerConfiguration var1);

        default public Builder crawlerConfiguration(Consumer<WebCrawlerConfiguration.Builder> crawlerConfiguration) {
            return this.crawlerConfiguration((WebCrawlerConfiguration)((WebCrawlerConfiguration.Builder)WebCrawlerConfiguration.builder().applyMutation(crawlerConfiguration)).build());
        }

        public Builder sourceConfiguration(WebSourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<WebSourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((WebSourceConfiguration)((WebSourceConfiguration.Builder)WebSourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }
    }
}

