/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.FlowVersionSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowVersionsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowVersionsResponse;

public class ListFlowVersionsIterable
implements SdkIterable<ListFlowVersionsResponse> {
    private final BedrockAgentClient client;
    private final ListFlowVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowVersionsIterable(BedrockAgentClient client, ListFlowVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowVersionsResponseFetcher();
    }

    public Iterator<ListFlowVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowVersionSummary> flowVersionSummaries() {
        Function<ListFlowVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowVersionSummaries() != null) {
                return response.flowVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowVersionsResponseFetcher
    implements SyncPageFetcher<ListFlowVersionsResponse> {
        private ListFlowVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowVersionsResponse nextPage(ListFlowVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowVersionsIterable.this.client.listFlowVersions(ListFlowVersionsIterable.this.firstRequest);
            }
            return ListFlowVersionsIterable.this.client.listFlowVersions((ListFlowVersionsRequest)((Object)ListFlowVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

